/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.hover;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.taginfo.XMLTagInfoHoverProcessor;
import org.w3c.dom.Node;

public class XMLReferencesInfoHoverProcessor
extends XMLTagInfoHoverProcessor {
    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        ITextRegion region;
        String result = null;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode parentNode = (IDOMNode)node;
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentPosition);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentPosition)) != null) {
            result = this.computeRegionHelp(treeNode, parentNode, flatNode, region, documentPosition);
        }
        return result;
    }

    protected String computeRegionHelp(IndexedRegion treeNode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, int documentPosition) {
        String result = null;
        if (region == null) {
            return null;
        }
        String regionType = region.getType();
        if (regionType == "XML_TAG_NAME") {
            result = this.computeTagNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
            result = this.computeTagAttNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
            flatNode.getStart();
            region.getStart();
            result = this.computeTagAttValueHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        }
        if (regionType == "XML_CONTENT") {
            flatNode.getStart();
            result = this.computeXMLContentValueHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        }
        return result;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        String regionType;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        if (region != null && ((regionType = region.getType()) == "XML_TAG_NAME" || regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_VALUE" || regionType == "XML_CONTENT")) {
            try {
                IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
                if (offset > line.getOffset() && offset < line.getOffset() + line.getLength() && offset < flatNode.getTextEndOffset(region)) {
                    return new Region(flatNode.getStartOffset(region), region.getTextLength());
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
        }
        return null;
    }

    protected String computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        String textInfo;
        IDOMAttr attr = DOMUtils.getAttrByRegion((IDOMNode)xmlnode, (ITextRegion)region);
        if (attr != null && !StringUtils.isEmpty((String)(textInfo = this.getTextInfo((IDOMNode)attr)))) {
            return textInfo;
        }
        return super.computeTagAttValueHelp(xmlnode, parentNode, flatNode, region);
    }

    private String getTextInfo(IDOMNode selectedNode) {
        IXMLReference reference = XMLReferencesManager.getInstance().getXMLReference((Node)selectedNode, selectedNode.getModel().getContentTypeIdentifier());
        if (reference != null) {
            StringBuilder infos = null;
            IFile file = DOMUtils.getFile((IDOMNode)selectedNode);
            if (reference.isExpression()) {
                IXMLReferenceToExpression expression = (IXMLReferenceToExpression)reference;
                IXMLSearcher searcher = expression.getSearcher();
                if (searcher != null) {
                    String textInfo = searcher.searchForTextHover(selectedNode, -1, DOMUtils.getNodeValue((Node)selectedNode), -1, -1, file, expression);
                    infos = this.getTextHover(infos, textInfo);
                }
            } else {
                List<IXMLReferenceTo> to = reference.getTo();
                for (IXMLReferenceTo referenceTo : to) {
                    IXMLSearcher searcher = referenceTo.getSearcher();
                    if (searcher == null) continue;
                    String textInfo = searcher.searchForTextHover(selectedNode, -1, DOMUtils.getNodeValue((Node)selectedNode), -1, -1, file, referenceTo);
                    infos = this.getTextHover(infos, textInfo);
                }
            }
            if (infos != null && infos.length() > 0) {
                return infos.toString();
            }
        }
        return null;
    }

    private StringBuilder getTextHover(StringBuilder infos, String textInfo) {
        if (!StringUtils.isEmpty((String)textInfo)) {
            if (infos == null) {
                infos = new StringBuilder();
            } else {
                infos.append("<br /><br />");
            }
            infos.append(textInfo);
        }
        return infos;
    }

    private String computeXMLContentValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        return this.getTextInfo(xmlnode);
    }
}

