/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.searchers.expressions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.searchers.expressions.IXMLExpressionParser;

public class XMLExpressionParserManager
extends AbstractRegistryManager {
    private static XMLExpressionParserManager INSTANCE = new XMLExpressionParserManager();
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String EXPRESSION_PARSER_ELT = "parser";
    private static final String EXPRESSION_PARSERS_EXTENSION_POINT = "expressionParsers";
    private Map<String, IXMLExpressionParser> expressionParserById = null;

    public static XMLExpressionParserManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.expressionParserById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addParser(this.expressionParserById, cf);
        }
    }

    private synchronized void addParser(Map<String, IXMLExpressionParser> expressionParserById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (EXPRESSION_PARSER_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    Object o = ce.createExecutableExtension(CLASS_ATTR);
                    if (o instanceof IXMLExpressionParser) {
                        expressionParserById.put(id, (IXMLExpressionParser)o);
                    }
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load expressionParser for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IXMLExpressionParser getParser(String parserId) {
        if (StringUtils.isEmpty((String)parserId)) {
            return null;
        }
        if (this.expressionParserById == null) {
            this.loadParsers();
        }
        return this.expressionParserById.get(parserId);
    }

    private synchronized void loadParsers() {
        if (this.expressionParserById != null) {
            return;
        }
        HashMap<String, IXMLExpressionParser> expressionParserById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", EXPRESSION_PARSERS_EXTENSION_POINT);
            expressionParserById = new HashMap(cf.length);
            this.addParser(expressionParserById, cf);
        } else {
            expressionParserById = new HashMap<String, IXMLExpressionParser>();
        }
        this.expressionParserById = expressionParserById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return EXPRESSION_PARSERS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

