/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.references;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.util.FileUtils;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReference;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.references.XMLReferencePathResult;
import org.eclipse.wst.xml.search.editor.references.filters.IXMLReferenceFilter;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.expressions.IXMLExpressionParser;
import org.w3c.dom.Node;

public class XMLReferencesUtil {
    public static IXMLReference getXMLReference(Node node, IFile file) {
        return XMLReferencesUtil.getXMLReference(node, FileUtils.getContentTypeId((IFile)file));
    }

    public static IXMLReference getXMLReference(Node node, String contentTypeId) {
        return XMLReferencesManager.getInstance().getXMLReference(node, contentTypeId);
    }

    public static List<IXMLReference> getXMLReferenceInversed(Node node, String contentTypeId) {
        return XMLReferencesManager.getInstance().getXMLReferenceInversed(node, contentTypeId);
    }

    public static boolean match(Node node, IXMLReferencePath referencePath) {
        return XMLReferencesManager.getInstance().match(node, referencePath);
    }

    public static IXMLReference createXMLReference(String fromPath, String fromTargetNodes, Namespaces namespaces, String querySpecificationId, String[] contentTypeIds, IXMLReferenceFilter filter, IXMLReferenceValidator validator) {
        return new XMLReference(fromPath, fromTargetNodes, namespaces, querySpecificationId, contentTypeIds, filter, validator);
    }

    public static IXMLReferenceToExpression createXMLReferenceToExpression(String fromPath, String fromTargetNodes, Namespaces namespaces, String querySpecificationId, String[] contentTypeIds, IXMLReferenceFilter filter, IXMLReferenceValidator validator, IXMLExpressionParser parser, IXMLSearcher expressionSearcher) {
        return new XMLReferenceToExpression(fromPath, fromTargetNodes, namespaces, querySpecificationId, contentTypeIds, filter, validator, parser, expressionSearcher);
    }

    public static void registerXMLReference(IXMLReference reference) {
        XMLReferencesManager.getInstance().registerXMReference(reference);
    }

    public static XMLReferencePathResult getXMLReferencesByPathTo(String path, String contentTypeId) {
        return new XMLReferencePathResult(XMLReferencesManager.getInstance().getXMLReferencesByPathTo(path, contentTypeId), true);
    }

    public static XMLReferencePathResult getReferencePath(Node selectedNode, IFile file) {
        return XMLReferencesUtil.getReferencePath(selectedNode, FileUtils.getContentTypeId((IFile)file));
    }

    public static XMLReferencePathResult getReferencePath(Node selectedNode, String contentTypeId) {
        List<IXMLReference> references = XMLReferencesUtil.getXMLReferenceInversed(selectedNode, contentTypeId);
        if (references != null && references.size() > 0) {
            XMLReferencePathResult referencePaths = new XMLReferencePathResult(references.size(), false);
            for (IXMLReference reference : references) {
                referencePaths.add(reference.getFrom());
            }
            return referencePaths;
        }
        IXMLReference reference = XMLReferencesUtil.getXMLReference(selectedNode, contentTypeId);
        if (reference != null) {
            IXMLReferencePath referencePath = null;
            for (IXMLReferenceTo referenceTo : reference.getTo()) {
                if (referenceTo.getType() != IXMLReferenceTo.ToType.XML) continue;
                referencePath = (IXMLReferencePath)referenceTo;
                break;
            }
            if (referencePath != null) {
                return XMLReferencesUtil.getXMLReferencesByPathTo(referencePath.getKeyPath(), contentTypeId);
            }
        }
        return null;
    }

    public static Collection<IXMLReference> getAllReferencesWithOneReferenceTo(IXMLReferenceTo.ToType toType) {
        return XMLReferencesManager.getInstance().getAllReferencesWithOneReferenceTo(toType);
    }
}

