/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.contentassist.JavaCompletionUtils;
import org.eclipse.wst.xml.search.editor.internal.hyperlink.JavaElementHyperlink;
import org.eclipse.wst.xml.search.editor.internal.util.EditorUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToJava;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.java.ValidationResultForJava;
import org.eclipse.wst.xml.search.editor.util.JdtUtils;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;

public class XMLSearcherForJava
implements IXMLSearcher {
    public static final IXMLSearcher INSTANCE = new XMLSearcherForJava();

    @Override
    public void searchForCompletion(Object selectedNode, String mathingString, String forceBeforeText, String forceEndText, IFile file, IXMLReferenceTo referenceTo, IContentAssistProposalRecorder recorder) {
        IXMLReferenceToJava referenceToJava = (IXMLReferenceToJava)referenceTo;
        IType[] classes = referenceToJava.getExtends(selectedNode, file);
        if (classes != null) {
            int i = 0;
            while (i < classes.length) {
                JavaCompletionUtils.addTypeHierachyAttributeValueProposals(mathingString, file, recorder, classes[i], 12);
                ++i;
            }
        } else {
            JavaCompletionUtils.addClassValueProposals(mathingString, file, recorder);
        }
    }

    @Override
    public void searchForHyperlink(Object selectedNode, int offset, String mathingString, int startOffset, int endOffset, IFile file, IXMLReferenceTo referenceTo, IRegion hyperlinkRegion, List<IHyperlink> hyperLinks, ITextEditor textEditor) {
        IType type = JdtUtils.getJavaType(file.getProject(), mathingString);
        if (type != null) {
            hyperLinks.add(new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)type));
        }
    }

    @Override
    public IValidationResult searchForValidation(Object selectedNode, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        ValidationResultForJava result = new ValidationResultForJava();
        IType type = JdtUtils.getJavaType(file.getProject(), mathingString);
        if (type != null) {
            result.setNbElements(1);
            IType[] superTypes = ((IXMLReferenceToJava)referenceTo).getExtends(selectedNode, file);
            if (superTypes != null && superTypes.length > 0) {
                boolean isHierarchyCorrect = false;
                IType[] iTypeArray = superTypes;
                int n = superTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superType = iTypeArray[n2];
                    try {
                        if (JdtUtils.hierarchyContainsComponent(type, superType.getFullyQualifiedName())) {
                            isHierarchyCorrect = true;
                            break;
                        }
                    }
                    catch (JavaModelException e) {
                        Trace.trace((byte)3, e.getMessage(), e);
                    }
                    ++n2;
                }
                if (!isHierarchyCorrect) {
                    result.setNbElements(-1);
                }
            }
        }
        return result;
    }

    @Override
    public String searchForTextHover(Object selectedNode, int offset, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        IType type = JdtUtils.getJavaType(file.getProject(), mathingString);
        if (type != null && type instanceof IMember) {
            return new ProposalInfo((IMember)type).getInfo(EditorUtils.getProgressMonitor());
        }
        return null;
    }
}

