/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.statics;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wst.xml.search.core.statics.IStaticValue;
import org.eclipse.wst.xml.search.core.statics.IStaticValueCollector;
import org.eclipse.wst.xml.search.core.statics.IStaticValueVisitor;
import org.eclipse.wst.xml.search.editor.statics.StaticValueDocument;

public class JavaStringLiteralDocumentVisitor
implements IStaticValueVisitor {
    public void visit(Object selectedNode, IFile file, String matching, boolean startsWith, IStaticValueCollector collector) {
        IFile javaFile = this.getFile(selectedNode, file);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(JavaCore.createCompilationUnitFrom((IFile)javaFile));
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(StringLiteral node) {
                ASTNode parent = JavaStringLiteralDocumentVisitor.this.accept(node);
                if (parent != null) {
                    boolean match;
                    String stringValue = node.getLiteralValue();
                    boolean bl = match = startsWith ? stringValue.startsWith(matching) : stringValue.equals(matching);
                    if (match) {
                        collector.add((IStaticValue)new StaticValueDocument(stringValue, parent.toString(), node.getStartPosition() + 1, stringValue.length(), (IResource)javaFile));
                    }
                }
                return true;
            }
        };
        cu.accept(visitor);
    }

    protected ASTNode accept(StringLiteral node) {
        ASTNode parent = node.getParent();
        return parent != null && parent.getNodeType() == 14 ? parent : null;
    }

    protected IFile getFile(Object selectedNode, IFile file) {
        return file;
    }
}

