/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.Reader;

public class JsonHelper {
    public static String getString(JsonObject json, String name) {
        JsonValue value = json.get(name);
        return JsonHelper.getString(value);
    }

    public static String getString(JsonValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.asString();
        }
        return value.toString();
    }

    public static Integer getInteger(JsonObject json, String name) {
        JsonValue value = json.get(name);
        return value == null ? null : Integer.valueOf(value.asInt());
    }

    public static Boolean getBoolean(JsonObject json, String name) {
        JsonValue value = json.get(name);
        return value == null ? null : Boolean.valueOf(value.asBoolean());
    }

    public static boolean getBoolean(JsonObject json, String name, boolean defaultValue) {
        Boolean result = JsonHelper.getBoolean(json, name);
        return result != null ? result : defaultValue;
    }

    public static Long getLong(JsonObject json, String name) {
        JsonValue value = json.get(name);
        return value == null ? null : Long.valueOf(value.asLong());
    }

    public static Object getValue(JsonValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber()) {
            return value.asInt();
        }
        if (value.isNull()) {
            return null;
        }
        return value;
    }

    public static void readFrom(Reader reader, JsonObject to) throws IOException {
        JsonHelper.copy(JsonObject.readFrom((Reader)reader), to);
    }

    public static void copy(JsonObject from, JsonObject to) {
        if (from != null) {
            for (JsonObject.Member member : from) {
                to.set(member.getName(), member.getValue());
            }
        }
    }

    public static boolean isSameJson(JsonValue value1, JsonValue value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals((Object)value2);
    }
}

