/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.outline;

import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.outline.ITernOutlineCollector;
import tern.server.protocol.outline.JSNode;
import tern.server.protocol.outline.JSNodeRoot;

public class TernOutlineResultProcessor
implements ITernResultProcessor<ITernOutlineCollector> {
    public static final TernOutlineResultProcessor INSTANCE = new TernOutlineResultProcessor();
    private static final String OUTLINE_FIELD_NAME = "outline";
    private static final String CHILDREN_FIELD_NAME = "children";

    @Override
    public void process(TernDoc doc, IJSONObjectHelper jsonObjectHelper, Object jsonObject, ITernOutlineCollector collector) {
        Iterable<Object> outline = jsonObjectHelper.getList(jsonObject, OUTLINE_FIELD_NAME);
        JSNodeRoot root = new JSNodeRoot();
        if (outline != null) {
            this.addChildren(outline, root, jsonObjectHelper);
        }
        collector.setRoot(root);
    }

    protected void addChildren(Iterable<Object> jsonNodes, JSNode parent, IJSONObjectHelper helper) {
        String name = null;
        String type = null;
        String kind = null;
        Long start = null;
        Long end = null;
        String file = null;
        JSNode node = null;
        for (Object jsonNode : jsonNodes) {
            name = helper.getText(jsonNode, "name");
            type = helper.getText(jsonNode, "type");
            kind = helper.getText(jsonNode, "kind");
            start = helper.getLong(jsonNode, "start");
            end = helper.getLong(jsonNode, "end");
            file = helper.getText(jsonNode, "file");
            node = new JSNode(name, type, kind, start, end, file, parent);
            Iterable<Object> jsonChildren = helper.getList(jsonNode, CHILDREN_FIELD_NAME);
            if (jsonChildren == null) continue;
            this.addChildren(jsonChildren, node, helper);
        }
    }
}

