/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import tern.ITernProject;
import tern.TernException;
import tern.metadata.ModuleDependenciesComparator;
import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.repository.ITernRepository;
import tern.server.BasicTernDef;
import tern.server.BasicTernPlugin;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.ITernPlugin;
import tern.server.ModuleType;
import tern.server.TernModuleConfigurable;
import tern.server.TernModuleInfo;
import tern.utils.StringUtils;

public class TernModuleHelper {
    public static List<ITernModule> groupByType(List<ITernModule> modules) {
        ArrayList<ITernModule> groupedModules = new ArrayList<ITernModule>();
        HashMap<String, TernModuleConfigurable> wrappers = null;
        for (ITernModule module : modules) {
            TernModuleConfigurable wrapper;
            if (!TernModuleHelper.isConfigurableModule(module)) {
                groupedModules.add(module);
                continue;
            }
            if (wrappers == null) {
                wrappers = new HashMap<String, TernModuleConfigurable>();
            }
            if ((wrapper = (TernModuleConfigurable)wrappers.get(module.getType())) == null) {
                wrapper = new TernModuleConfigurable(module);
                wrappers.put(module.getType(), wrapper);
                groupedModules.add(wrapper);
                continue;
            }
            wrapper.addModule(module);
        }
        return groupedModules;
    }

    public static boolean isConfigurableModule(ITernModule module) {
        TernModuleMetadata metadata = module.getMetadata();
        return !StringUtils.isEmpty(module.getVersion()) || metadata != null && (metadata.hasOptions() || metadata.isLinter());
    }

    public static void update(List<ITernDef> defs, List<ITernPlugin> plugins, ITernModule module) {
        TernModuleHelper.update(defs, plugins, null, module);
    }

    private static void update(List<ITernDef> defs, List<ITernPlugin> plugins, JsonValue options, ITernModule module) {
        switch (module.getModuleType()) {
            case Def: {
                defs.add((ITernDef)module);
                break;
            }
            case Plugin: {
                plugins.add((ITernPlugin)module);
                break;
            }
            case Configurable: {
                ITernModule wrappedModule = ((ITernModuleConfigurable)module).getWrappedModule();
                JsonValue wrappedOptions = ((ITernModuleConfigurable)module).getOptions();
                TernModuleHelper.update(defs, plugins, wrappedOptions, wrappedModule);
            }
        }
    }

    public static void update(ITernModule module, ITernProject ternProject) {
        TernModuleHelper.update(module, null, ternProject);
    }

    public static void update(ITernModule module, JsonValue options, ITernProject ternProject) {
        switch (module.getModuleType()) {
            case Def: {
                ternProject.addLib((ITernDef)module);
                break;
            }
            case Plugin: {
                ternProject.addPlugin((ITernPlugin)module, options);
                break;
            }
            case Configurable: {
                ITernModule wrappedModule = ((ITernModuleConfigurable)module).getWrappedModule();
                JsonValue wrappedOptions = ((ITernModuleConfigurable)module).getOptions();
                TernModuleHelper.update(wrappedModule, wrappedOptions, ternProject);
            }
        }
    }

    public static ITernModuleConfigurable findConfigurable(ITernModule module, JsonValue options, List<ITernModule> allModules) throws TernException {
        String version = module.getVersion();
        for (ITernModule f : allModules) {
            if (f.getModuleType() != ModuleType.Configurable || !f.getType().equals(module.getType())) continue;
            ITernModuleConfigurable c = (ITernModuleConfigurable)f;
            if (!StringUtils.isEmpty(version)) {
                c.setVersion(version);
            }
            if (options != null) {
                if (options.isObject()) {
                    c.setOptions((JsonValue)new JsonObject((JsonObject)options));
                } else if (options.isNull()) {
                    c.setOptions(options);
                }
            }
            return (ITernModuleConfigurable)f;
        }
        return null;
    }

    public static boolean hasOptions(ITernModule module) {
        if (module == null || module.getMetadata() == null) {
            return false;
        }
        return module.getMetadata().hasOptions();
    }

    public static ITernModule createModule(File file, ITernRepository repository, ITernRepository defaultRepository) {
        String filename = file.getName();
        if (file.isDirectory()) {
            if (filename.startsWith("tern-")) {
                TernModuleInfo info = new TernModuleInfo(filename.substring("tern-".length(), filename.length()));
                TernModuleMetadata metadata = TernModuleHelper.getMetadata(info.getType(), file, repository, defaultRepository);
                if (metadata != null && metadata.isDef()) {
                    return new BasicTernDef(info, metadata);
                }
                return new BasicTernPlugin(info, metadata);
            }
        } else if (file.isFile()) {
            return TernModuleHelper.createModule(filename, repository, defaultRepository);
        }
        return null;
    }

    public static ITernModule createModule(String filename, ITernRepository repository, ITernRepository defaultRepository) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        String fileExtension = filename.substring(index + 1, filename.length());
        filename = filename.substring(0, index);
        if (fileExtension.equals("json")) {
            TernModuleInfo info = new TernModuleInfo(filename);
            TernModuleMetadata metadata = TernModuleHelper.getMetadata(info.getType(), null, repository, defaultRepository);
            return new BasicTernDef(info, metadata);
        }
        if (fileExtension.equals("js")) {
            TernModuleInfo info = new TernModuleInfo(filename);
            TernModuleMetadata metadata = TernModuleHelper.getMetadata(info.getType(), null, repository, defaultRepository);
            return new BasicTernPlugin(info, metadata);
        }
        return null;
    }

    private static TernModuleMetadata getMetadata(String moduleName, File moduleDir, ITernRepository repository, ITernRepository defaultRepository) {
        TernModuleMetadata metadata = null;
        if (moduleDir != null && moduleDir.isDirectory()) {
            try {
                metadata = TernModuleMetadataManager.loadMetadata(moduleDir, moduleName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (metadata == null && repository != null) {
            metadata = repository.getDefaultMetadata(moduleName);
        }
        if (metadata == null && defaultRepository != null) {
            metadata = defaultRepository.getDefaultMetadata(moduleName);
        }
        return metadata;
    }

    public static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    public static String getFileName(ITernModule module) {
        switch (module.getModuleType()) {
            case Def: {
                return module.getName() + '.' + "json";
            }
        }
        return module.getName() + '.' + "js";
    }

    public static void sort(List<ITernModule> modules) {
        TernModuleHelper.sort(modules, null);
    }

    public static void sort(List<ITernModule> modules, TernModuleMetadataManager manager) {
        new ModuleDependenciesComparator(modules, manager);
    }

    public static String getModulesAsString(ITernModule ... modules) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < modules.length) {
            if (i > 0) {
                s.append(",");
            }
            s.append(modules[i].getName());
            ++i;
        }
        return s.toString();
    }

    public static String getLabel(ITernModule module) {
        try {
            TernModuleMetadata metadata = module.getMetadata();
            if (metadata != null && !StringUtils.isEmpty(metadata.getLabel())) {
                return metadata.getLabel();
            }
        }
        catch (Exception exception) {}
        return module.getName();
    }
}

