/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.model.internal;

import com.liferay.ide.service.core.model.ServiceBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PackagePathValidationService
extends ValidationService {
    public Status compute() {
        Value<String> packagePath = ((ServiceBuilder)this.context().find(ServiceBuilder.class)).getPackagePath();
        String packPathVal = (String)packagePath.content();
        if (packPathVal == null) {
            return Status.createErrorStatus((String)Msgs.packagePathNotEmpty);
        }
        IStatus javaStatus = JavaConventions.validatePackageName((String)packPathVal, (String)"1.5", (String)"1.5");
        if (javaStatus.getSeverity() == 4) {
            return Status.createErrorStatus((String)(String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage()));
        }
        if (javaStatus.getSeverity() == 2) {
            return Status.createWarningStatus((String)(String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage()));
        }
        return Status.createOkStatus();
    }

    private static class Msgs
    extends NLS {
        public static String packagePathNotEmpty;

        static {
            Msgs.initializeMessages((String)PackagePathValidationService.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

