/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.ui.handlers;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.job.BuildServiceJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class BuildServiceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput editorInput;
        IStatus retval = null;
        IProject project = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object selected = structuredSelection.getFirstElement();
            if (selected instanceof IResource) {
                project = ((IResource)selected).getProject();
            } else if (selected instanceof IJavaElement) {
                project = ((IJavaElement)selected).getJavaProject().getProject();
            } else if (selected instanceof PackageFragmentRootContainer) {
                project = ((PackageFragmentRootContainer)selected).getJavaProject().getProject();
            }
        }
        if (project == null && (editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) != null && editorInput.getAdapter(IResource.class) != null) {
            project = ((IResource)editorInput.getAdapter(IResource.class)).getProject();
        }
        if (project != null) {
            retval = this.executeServiceBuild(project);
        }
        return retval;
    }

    protected IStatus executeServiceBuild(IProject project) {
        IStatus retval = null;
        try {
            new BuildServiceJob(project).schedule();
            retval = Status.OK_STATUS;
        }
        catch (Exception e) {
            retval = ServiceCore.createErrorStatus((String)"Unable to execute build-service command", (Exception)e);
        }
        return retval;
    }

    protected IFile getServiceFile(IProject project) {
        Path path;
        IFile serviceFile;
        IFolder docroot = CoreUtil.getDefaultDocrootFolder((IProject)project);
        if (docroot != null && docroot.exists() && (serviceFile = docroot.getFile((IPath)(path = new Path("WEB-INF/service.xml")))).exists()) {
            return serviceFile;
        }
        return null;
    }
}

