/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IPasswordStore;

public class JSchLocation
extends PlatformObject
implements IJSchLocation {
    private static int DEFAULT_PORT = 22;
    private String user;
    private String password;
    private String host;
    private int port = DEFAULT_PORT;
    private boolean userFixed = true;
    private String comment = null;
    private IPasswordStore passwordStore = null;

    public JSchLocation(String user, String host, int port) {
        this.user = user;
        this.host = host;
        this.port = port;
    }

    public JSchLocation(String user, String host) {
        this(user, host, DEFAULT_PORT);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String user) {
        if (this.userFixed) {
            throw new UnsupportedOperationException();
        }
        this.user = user;
    }

    public String getUsername() {
        return this.user == null ? "" : this.user;
    }

    public void setPassword(String password) {
        if (password != null) {
            this.password = password;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPasswordStore(IPasswordStore store) {
        this.passwordStore = store;
    }

    public IPasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public String toString() {
        return String.valueOf(this.user) + "@" + this.host + (this.port == DEFAULT_PORT ? "" : ":" + new Integer(this.port).toString());
    }
}

