/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    public static final Map<String, QName> SCHEMA_QNAMES = new HashMap<String, QName>(){
        {
            this.put("any", Constants.ANY_QNAME);
            this.put("anySimpleType", Constants.ANY_SIMPLE_TYPE_QNAME);
            this.put("base64Binary", Constants.BASE_64_BINARY_QNAME);
            this.put("boolean", Constants.BOOLEAN_QNAME);
            this.put("byte", Constants.BYTE_QNAME);
            this.put("date", Constants.DATE_QNAME);
            this.put("dateTime", Constants.DATE_TIME_QNAME);
            this.put("decimal", Constants.DECIMAL_QNAME);
            this.put("double", Constants.DOUBLE_QNAME);
            this.put("float", Constants.FLOAT_QNAME);
            this.put("hexBinary", Constants.HEX_BINARY_QNAME);
            this.put("int", Constants.INT_QNAME);
            this.put("integer", Constants.INTEGER_QNAME);
            this.put("long", Constants.LONG_QNAME);
            this.put("QName", Constants.QNAME_QNAME);
            this.put("short", Constants.SHORT_QNAME);
            this.put("string", Constants.STRING_QNAME);
            this.put("time", Constants.TIME_QNAME);
            this.put("unsignedByte", Constants.UNSIGNED_BYTE_QNAME);
            this.put("unsignedInt", Constants.UNSIGNED_INT_QNAME);
            this.put("unsignedShort", Constants.UNSIGNED_SHORT_QNAME);
            this.put("swaRef", Constants.SWA_REF_QNAME);
        }
    };
    private static final char COLON = ':';
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private NamespaceResolver namespaceResolver;
    private String xPath;

    public QNameTransformer(String xPath) {
        this.xPath = xPath;
    }

    public void initialize(AbstractTransformationMapping mapping) {
        this.transformationMapping = mapping;
        this.namespaceResolver = ((XMLDescriptor)mapping.getDescriptor()).getNamespaceResolver();
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        if (record == null) {
            return null;
        }
        String value = (String)record.get((Object)this.xPath);
        if (value == null) {
            return null;
        }
        QName qName = null;
        int index = value.lastIndexOf(58);
        if (index > -1) {
            String prefix = value.substring(0, index);
            String localName = value.substring(index + 1);
            String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(prefix);
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                qName = SCHEMA_QNAMES.get(localName);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localName, prefix == null ? DEFAULT_NAMESPACE_PREFIX : prefix);
                }
            } else {
                qName = new QName(namespaceURI == null ? DEFAULT_NAMESPACE_PREFIX : namespaceURI, localName, prefix == null ? DEFAULT_NAMESPACE_PREFIX : prefix);
            }
            return qName;
        }
        String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        qName = new QName(namespaceURI, value);
        return qName;
    }

    public Object buildFieldValue(Object instance, String fieldName, Session session) {
        if (instance == null) {
            return null;
        }
        QName qName = (QName)this.transformationMapping.getAttributeValueFromObject(instance);
        if (qName.getNamespaceURI() == null) {
            return qName.getLocalPart();
        }
        String namespaceURI = qName.getNamespaceURI();
        String prefix = this.namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (prefix == null) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }
}

