/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.AutoMigrateException;
import com.liferay.blade.api.AutoMigrator;
import com.liferay.blade.api.Problem;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.MarkDoneAction;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AutoCorrectAction
extends SelectionProviderAction
implements IAction {
    public AutoCorrectAction(ISelectionProvider provider) {
        super(provider, "Correct automatically");
    }

    public static void run(final Problem problem, final ISelectionProvider provider) {
        final IResource file = MigrationUtil.getIResourceFromProblem(problem);
        final BundleContext context = FrameworkUtil.getBundle(AutoCorrectAction.class).getBundleContext();
        new WorkspaceJob("Auto correcting migration problem."){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    String autoCorrectKey = problem.autoCorrectContext.substring(0, problem.autoCorrectContext.indexOf(":"));
                    Collection refs = context.getServiceReferences(AutoMigrator.class, "(auto.correct=" + autoCorrectKey + ")");
                    for (ServiceReference ref : refs) {
                        ArrayList<Problem> problems = new ArrayList<Problem>();
                        problems.add(problem);
                        AutoMigrator autoMigrator = (AutoMigrator)context.getService(ref);
                        autoMigrator.correctProblems(problem.file, problems);
                    }
                    file.refreshLocal(1, monitor);
                    new MarkDoneAction().run(problem, provider);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                }
                catch (AutoMigrateException | CoreException e) {
                    return ProjectUI.createErrorStatus("Unable to auto correct problem", (Exception)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void run() {
        Problem problem = MigrationUtil.getProblemFromSelection(this.getSelection());
        AutoCorrectAction.run(problem, this.getSelectionProvider());
    }
}

