/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.ExpandAllAction;
import com.liferay.ide.project.ui.migration.MarkDoneAction;
import com.liferay.ide.project.ui.migration.MarkUndoneAction;
import com.liferay.ide.project.ui.migration.MigrationActionProvider;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.migration.MigratorComparator;
import com.liferay.ide.project.ui.migration.RunMigrationToolAction;
import com.liferay.ide.ui.util.UIUtil;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.actions.CommonActionDescriptorManager;
import org.eclipse.ui.internal.navigator.actions.CommonActionProviderDescriptor;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorActionService;

public class MigrationView
extends CommonNavigator
implements IDoubleClickListener {
    public static final String ID = "com.liferay.ide.project.ui.migrationView";
    private static final Image IMAGE_CHECKED = ProjectUI.getDefault().getImageRegistry().get("checked.image");
    private static final Image IMAGE_UNCHECKED = ProjectUI.getDefault().getImageRegistry().get("unchecked.image");
    private Browser _browser;
    private TableViewer _problemsViewer;
    private MigratorComparator _comparator;

    private void createColumns(final TableViewer _problemsViewer) {
        String[] titles = new String[]{"Resolved", "Line", "Problem"};
        int[] bounds = new int[]{65, 55, 200};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], _problemsViewer);
        col.setEditingSupport(new EditingSupport((ColumnViewer)_problemsViewer){

            protected void setValue(Object element, Object value) {
                if (value == Boolean.TRUE) {
                    new MarkDoneAction().run((Problem)element, (ISelectionProvider)_problemsViewer);
                } else {
                    new MarkUndoneAction().run((Problem)element, (ISelectionProvider)_problemsViewer);
                }
            }

            protected Object getValue(Object element) {
                if (((Problem)element).getStatus() == 1) {
                    return true;
                }
                return false;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)_problemsViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                Problem p = (Problem)element;
                if (p.getStatus() == 1) {
                    return IMAGE_CHECKED;
                }
                return IMAGE_UNCHECKED;
            }

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], _problemsViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Problem p = (Problem)element;
                return p.lineNumber > -1 ? String.valueOf(p.lineNumber) : "";
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2], _problemsViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Problem p = (Problem)element;
                return p.title;
            }

            public void update(ViewerCell cell) {
                super.update(cell);
                Table table = _problemsViewer.getTable();
                table.getColumn(2).pack();
            }
        });
    }

    public void createPartControl(Composite parent) {
        SashForm viewParent = new SashForm(parent, 256);
        viewParent.setLayout((Layout)new FillLayout(256));
        super.createPartControl((Composite)viewParent);
        SashForm detailParent = new SashForm((Composite)viewParent, 512);
        viewParent.setWeights(new int[]{2, 3});
        this._problemsViewer = new TableViewer((Composite)detailParent, 68354);
        this.createColumns(this._problemsViewer);
        Table table = this._problemsViewer.getTable();
        table.setHeaderVisible(true);
        this._problemsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._problemsViewer.setComparer(null);
        this._comparator = new MigratorComparator();
        this._problemsViewer.setComparator((ViewerComparator)this._comparator);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MigrationView.this.fillContextMenu(manager, (ISelectionProvider)MigrationView.this._problemsViewer);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._problemsViewer.getControl());
        this._problemsViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._problemsViewer);
        this.contributeToActionBars();
        this._problemsViewer.addDoubleClickListener((IDoubleClickListener)this);
        CommonActionProvider ap = this.getCommonActionProvider((ISelection)new StructuredSelection((Object)new Problem()));
        if (ap instanceof MigrationActionProvider) {
            MigrationActionProvider mp = (MigrationActionProvider)ap;
            mp.makeActions((ISelectionProvider)this._problemsViewer);
            mp.registerSelectionProvider((ISelectionProvider)this._problemsViewer);
        }
        this._browser = new Browser((Composite)detailParent, 2048);
        detailParent.setWeights(new int[]{2, 3});
        this.getCommonViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List<Problem> problems = MigrationUtil.getProblemsFromTreeNode(event.getSelection());
                if (problems != null && problems.size() > 0) {
                    MigrationView.this._problemsViewer.setInput((Object)problems.toArray());
                    MigrationView.this._problemsViewer.setSelection((ISelection)new StructuredSelection((Object)problems.get(0)));
                } else {
                    MigrationView.this._problemsViewer.setInput(null);
                }
            }
        });
        this._problemsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                UIUtil.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MigrationView.this.updateForm(event);
                    }
                }, (long)50L);
            }
        });
        this.getCommonViewer().addDoubleClickListener((IDoubleClickListener)this);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, viewer.getTable().indexOf(column)));
        return viewerColumn;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        RunMigrationToolAction migrateAction = new RunMigrationToolAction("Run Migration Tool", this.getViewSite().getShell());
        ExpandAllAction expandAllAction = new ExpandAllAction("Expand All", this);
        manager.add((IAction)migrateAction);
        manager.add((IAction)expandAllAction);
    }

    public void doubleClick(DoubleClickEvent event) {
        Problem problem = MigrationUtil.getProblemFromSelection(event.getSelection());
        if (problem != null) {
            MigrationUtil.openEditor(problem);
        }
    }

    private void fillContextMenu(IMenuManager manager, ISelectionProvider provider) {
        CommonActionProvider instance = this.getCommonActionProvider(provider.getSelection());
        instance.setContext(new ActionContext(provider.getSelection()));
        instance.fillContextMenu(manager);
    }

    private String generateFormText(Problem problem) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form><p>");
        sb.append("<b>Problem:</b> " + problem.title + "<br/><br/>");
        sb.append("<b>Description:</b><br/>");
        sb.append("\t" + problem.summary + "<br/><br/>");
        if (problem.getAutoCorrectContext() != null && problem.autoCorrectContext.length() > 0) {
            sb.append("<a href='autoCorrect'>Correct this problem automatically</a><br/><br/>");
        }
        if (problem.html != null && problem.html.length() > 0) {
            sb.append("<a href='html'>See documentation for how to correct this problem.</a><br/><br/>");
        }
        if (problem.ticket != null && problem.ticket.length() > 0) {
            sb.append("<b>Tickets:</b> " + this.getLinkTags(problem.ticket) + "<br/><br/>");
        }
        sb.append("</p></form>");
        return sb.toString();
    }

    CommonActionProvider getCommonActionProvider(ISelection selection) {
        INavigatorContentService contentService = this.getCommonViewer().getCommonNavigator().getNavigatorContentService();
        ActionContext context = new ActionContext(selection);
        CommonActionProviderDescriptor[] providerDescriptors = CommonActionDescriptorManager.getInstance().findRelevantActionDescriptors(contentService, context);
        NavigatorActionService navigatorActionService = this.getCommonViewer().getCommonNavigator().getNavigatorActionService();
        return navigatorActionService.getActionProviderInstance(providerDescriptors[0]);
    }

    private String getLinkTags(String ticketNumbers) {
        String[] ticketNumberArray = ticketNumbers.split(",");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ticketNumberArray.length) {
            String ticketNumber = ticketNumberArray[i];
            sb.append("<a href='https://issues.liferay.com/browse/");
            sb.append(ticketNumber);
            sb.append("'>");
            sb.append(ticketNumber);
            sb.append("</a>");
            if (ticketNumberArray.length > 1 && i != ticketNumberArray.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationView.this._comparator.setColumn(index);
                int dir = MigrationView.this._comparator.getDirection();
                MigrationView.this._problemsViewer.getTable().setSortDirection(dir);
                MigrationView.this._problemsViewer.getTable().setSortColumn(column);
                MigrationView.this._problemsViewer.refresh();
            }
        };
    }

    private void updateForm(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Problem problem = MigrationUtil.getProblemFromSelection(selection);
        if (problem != null) {
            if (CoreUtil.isNullOrEmpty((String)problem.html)) {
                this._browser.setText(this.generateFormText(problem));
            } else {
                this._browser.setText(problem.html);
            }
        } else {
            this._browser.setUrl("about:blank");
        }
    }

    public TableViewer getProblemsViewer() {
        return this._problemsViewer;
    }
}

