/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.migration.MigrationView;
import com.liferay.ide.ui.util.UIUtil;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.actions.SelectionProviderAction;

public abstract class ProblemAction
extends SelectionProviderAction
implements IAction {
    public ProblemAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    protected void refreshTableViewer() {
        final MigrationView mv = (MigrationView)UIUtil.showView((String)"com.liferay.ide.project.ui.migrationView");
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                Object selection = ProblemAction.this.getStructuredSelection().getFirstElement();
                List<Problem> problems = null;
                if (selection instanceof IFile) {
                    IFile file = (IFile)selection;
                    problems = MigrationUtil.getProblemsFromResource((IResource)file);
                }
                if (problems != null && problems.size() > 0) {
                    mv.getProblemsViewer().setInput((Object)problems.toArray());
                    mv.getProblemsViewer().setSelection((ISelection)new StructuredSelection((Object)problems.get(0)));
                } else {
                    mv.getProblemsViewer().setInput(null);
                }
            }
        });
    }

    public void run() {
        List<Problem> Problems = MigrationUtil.getProblemsFromSelection(this.getSelection());
        for (Problem problem : Problems) {
            this.run(problem, this.getSelectionProvider());
        }
    }

    public void run(final Problem problem, final ISelectionProvider provider) {
        final IResource resource = MigrationUtil.getIResourceFromProblem(problem);
        new Job("Marking migration problem as done"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus retval = Status.OK_STATUS;
                if (resource != null && resource.exists()) {
                    IMarker marker = resource.getMarker(problem.getMarkerId());
                    if (marker != null) {
                        retval = ProblemAction.this.runWithMarker(problem, marker);
                        if (provider instanceof Viewer) {
                            final Viewer viewer = (Viewer)provider;
                            UIUtil.async((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    viewer.refresh();
                                }
                            });
                        }
                    } else {
                        retval = ProjectUI.createErrorStatus("Unable to get marker from file");
                    }
                } else {
                    retval = ProjectUI.createErrorStatus("Unable to get file from problem");
                }
                return retval;
            }
        }.schedule();
    }

    protected abstract IStatus runWithMarker(Problem var1, IMarker var2);

    public void selectionChanged(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        this.setEnabled(element instanceof Problem);
    }
}

