/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LiferayServerUI
extends AbstractUIPlugin {
    public static final String IMG_NOTIFICATION = "imgNotification";
    public static final String IMG_WIZ_RUNTIME = "imgWizRuntime";
    public static final String PLUGIN_ID = "com.liferay.ide.server.ui";
    private static URL ICON_BASE_URL;
    private static LiferayServerUI plugin;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();

    public static LiferayServerUI getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            LiferayServerUI.getDefault().getImageRegistry();
            return LiferayServerUI.getDefault().imageDescriptors.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void logError(Exception ex) {
        LiferayServerUI.getDefault().getLog().log(LiferayServerUI.createErrorStatus(ex));
    }

    public static IStatus createErrorStatus(Exception ex) {
        return new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex);
    }

    public static void logError(String msg, Exception ex) {
        LiferayServerUI.getDefault().getLog().log(LiferayServerUI.createErrorStatus(msg, ex));
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg, null);
    }

    public static IStatus createErrorStatus(String msg, Exception ex) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)ex);
    }

    public static IStatus logInfo(String msg, IStatus status) {
        return new Status(1, PLUGIN_ID, msg, status.getException());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        if (ICON_BASE_URL == null) {
            String pathSuffix = "icons/";
            ICON_BASE_URL = plugin.getBundle().getEntry(pathSuffix);
        }
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
        }
    }

    protected ImageRegistry createImageRegistry() {
        String[] pluginTypes;
        ImageRegistry registry = new ImageRegistry();
        String[] stringArray = pluginTypes = new String[]{"portlet", "hook", "ext", "layouttpl", "theme", "web"};
        int n = pluginTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.registerImage(registry, type, "/icons/e16/" + type + ".png");
            ++n2;
        }
        this.registerImage(registry, IMG_WIZ_RUNTIME, "wizban/liferay_wiz.png");
        this.registerImage(registry, IMG_NOTIFICATION, "e16/server.png");
        return registry;
    }
}

