/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.wst.server.core.IServer;

public class CreatePortalSettingsFileAction
extends AbstractServerRunningAction {
    private static final String PORTAL_EXT_PROPERTIES = "portal-ext.properties";

    @Override
    protected int getRequiredServerState() {
        return 7;
    }

    private IPath getSettingsFilePath() {
        IPath home;
        ILiferayRuntime liferayRuntime;
        IPath retval = null;
        if (this.selectedServer != null && (liferayRuntime = ServerUtil.getLiferayRuntime((IServer)this.selectedServer)) != null && (home = liferayRuntime.getLiferayHome()) != null && home.toFile().exists()) {
            retval = home.append(PORTAL_EXT_PROPERTIES);
        }
        return retval;
    }

    public void run(IAction action) {
        IPath settingsFilePath = this.getSettingsFilePath();
        if (settingsFilePath != null) {
            File newFile = settingsFilePath.toFile();
            try {
                if (newFile.createNewFile()) {
                    UIUtil.refreshCommonView((String)"org.eclipse.wst.server.ui.ServersView");
                    FileStoreEditorInput editorInput = new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(newFile));
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        page.openEditor((IEditorInput)editorInput, "com.liferay.ide.ui.editor.LiferayPortalPropertiesEditor");
                    }
                    catch (PartInitException e) {
                        LiferayServerUI.logError("Error opening properties editor.", (Exception)((Object)e));
                    }
                }
            }
            catch (IOException e) {
                LiferayServerUI.logError("Unable to create new portal settings file", e);
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        IPath settingsFile;
        super.selectionChanged(action, selection);
        if (action.isEnabled() && ((settingsFile = this.getSettingsFilePath()) == null || settingsFile.toFile().exists())) {
            action.setEnabled(false);
        }
    }
}

