/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.ILiferayServer;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import com.liferay.ide.server.util.WebServicesHelper;
import com.liferay.ide.ui.dialog.StringsFilteredDialog;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.WSExplorerLauncherCommand;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.monitor.GetMonitorCommand;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class TestWebServicesAction
extends AbstractServerRunningAction {
    public void run(IAction action) {
        ILiferayServer portalServer;
        if (this.selectedServer == null && this.selectedModule == null) {
            return;
        }
        URL webServicesListURL = null;
        Object[] names = null;
        WebServicesHelper helper = null;
        if (this.selectedServer != null) {
            portalServer = (ILiferayServer)this.selectedServer.loadAdapter(ILiferayServer.class, null);
            webServicesListURL = portalServer.getWebServicesListURL();
            helper = new WebServicesHelper(webServicesListURL);
            names = helper.getWebServiceNames();
        } else if (this.selectedModule != null) {
            this.selectedModule.getModule()[0].getProject();
            portalServer = (ILiferayServer)this.selectedModule.getServer().loadAdapter(ILiferayServer.class, null);
            try {
                webServicesListURL = new URL(portalServer.getPortalHomeUrl(), String.valueOf(this.selectedModule.getModule()[0].getName()) + "/axis");
            }
            catch (MalformedURLException e) {
                LiferayServerUI.logError(e);
                return;
            }
            helper = new WebServicesHelper(webServicesListURL);
            names = helper.getWebServiceNames();
            if (CoreUtil.empty((Object[])names)) {
                try {
                    webServicesListURL = new URL(portalServer.getPortalHomeUrl(), String.valueOf(this.selectedModule.getModule()[0].getName()) + "/api/axis");
                }
                catch (MalformedURLException e) {
                    LiferayServerUI.logError(e);
                    return;
                }
                helper = new WebServicesHelper(webServicesListURL);
                names = helper.getWebServiceNames();
            }
        }
        StringsFilteredDialog dialog = new StringsFilteredDialog(this.getActiveShell());
        dialog.setTitle(Msgs.webServiceSelection);
        dialog.setMessage(Msgs.selectWebService);
        dialog.setInput((Object)names);
        int retval = dialog.open();
        if (retval == 0) {
            String serviceName = dialog.getFirstResult().toString();
            String url = helper.getWebServiceWSDLURLByName(serviceName);
            String stateLocation = ExplorerPlugin.getInstance().getPluginStateLocation();
            String defaultFavoritesLocation = ExplorerPlugin.getInstance().getDefaultFavoritesLocation();
            WSExplorerLauncherCommand command = new WSExplorerLauncherCommand();
            command.setForceLaunchOutsideIDE(false);
            Vector launchOptions = new Vector();
            this.addLaunchOptions(launchOptions, url, stateLocation, defaultFavoritesLocation);
            command.setLaunchOptions(launchOptions.toArray(new LaunchOption[0]));
            command.execute();
        }
    }

    protected void addLaunchOptions(Vector launchOptions, String wsdlURL, String stateLocation, String defaultFavoritesLocation) {
        GetMonitorCommand getMonitorCmd = new GetMonitorCommand();
        getMonitorCmd.setMonitorService(true);
        getMonitorCmd.setCreate(false);
        getMonitorCmd.setWebServicesParser(new WebServicesParser());
        getMonitorCmd.setWsdlURI(wsdlURL);
        getMonitorCmd.execute(null, null);
        List endpoints = getMonitorCmd.getEndpoints();
        Iterator endpointsIt = endpoints.iterator();
        while (endpointsIt.hasNext()) {
            launchOptions.add(new LaunchOption("webServiceEndpoint", (String)endpointsIt.next()));
        }
        launchOptions.add(new LaunchOption("wsdl", wsdlURL));
        launchOptions.add(new LaunchOption("stateLocation", stateLocation));
        launchOptions.add(new LaunchOption("defaultFavoritesLocation", defaultFavoritesLocation));
    }

    @Override
    protected int getRequiredServerState() {
        return 2;
    }

    private static class Msgs
    extends NLS {
        public static String selectWebService;
        public static String webServiceSelection;

        static {
            Msgs.initializeMessages((String)TestWebServicesAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

