/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.navigator;

import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.action.EditPropertiesFileAction;
import com.liferay.ide.server.ui.action.OpenLiferayHomeFolderAction;
import com.liferay.ide.server.ui.navigator.PropertiesFile;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PropertiesActionProvider
extends CommonActionProvider {
    public static final String NEW_MENU_ID = "org.eclipse.wst.server.ui.internal.cnf.newMenuId";
    public static final String TOP_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.topSectionEnd";
    public static final String TOP_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.topSectionStart";
    private ICommonActionExtensionSite actionSite;
    private EditPropertiesFileAction editAction;
    private OpenLiferayHomeFolderAction openFolderAction;

    private void addListeners(CommonViewer tableViewer) {
        tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    Object data = sel.getFirstElement();
                    if (!(data instanceof PropertiesFile)) {
                        return;
                    }
                    PropertiesActionProvider.this.editAction.run();
                }
                catch (Exception e) {
                    LiferayServerUI.logError("Error opening kaleo workflow.", e);
                }
            }
        });
    }

    protected void addTopSection(IMenuManager menu, PropertiesFile file) {
        if (file != null) {
            menu.add((IAction)this.editAction);
            menu.add((IAction)this.openFolderAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.removeAll();
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        PropertiesFile file = null;
        if (selection != null && !selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof PropertiesFile) {
                file = (PropertiesFile)obj;
            }
            if (iterator.hasNext()) {
                file = null;
            }
        }
        menu.add((IContributionItem)this.invisibleSeparator(TOP_SECTION_START_SEPARATOR));
        this.addTopSection(menu, file);
        menu.add((IContributionItem)this.invisibleSeparator(TOP_SECTION_END_SEPARATOR));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void init(ICommonActionExtensionSite site) {
        StructuredViewer v;
        super.init(site);
        this.actionSite = site;
        ICommonViewerSite viewerSite = site.getViewSite();
        if (viewerSite instanceof ICommonViewerWorkbenchSite && (v = site.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)viewerSite;
            this.addListeners(cv);
            this.makeActions(cv, wsSite.getSelectionProvider());
        }
    }

    private Separator invisibleSeparator(String s) {
        Separator sep = new Separator(s);
        sep.setVisible(false);
        return sep;
    }

    private void makeActions(CommonViewer tableViewer, ISelectionProvider provider) {
        this.editAction = new EditPropertiesFileAction(provider);
        this.openFolderAction = new OpenLiferayHomeFolderAction(provider);
    }
}

