/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.navigator;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.ILiferayServer;
import com.liferay.ide.server.remote.IRemoteServer;
import com.liferay.ide.server.ui.navigator.PropertiesFile;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.navigator.AbstractNavigatorContentProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.server.core.IServer;

public class PropertiesContentProvider
extends AbstractNavigatorContentProvider {
    private final Map<String, PropertiesFile[]> propertiesFilesMap = new HashMap<String, PropertiesFile[]>();

    public void dispose() {
        this.propertiesFilesMap.clear();
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        if (this.shouldAddChildren(parent)) {
            ILiferayRuntime runtime;
            IServer server = (IServer)parent;
            Object[] propertiesFiles = this.propertiesFilesMap.get(server.getId());
            if (CoreUtil.isNullOrEmpty((Object[])propertiesFiles) && (runtime = ServerUtil.getLiferayRuntime((IServer)server)) != null) {
                final File liferayHome = runtime.getLiferayHome().toFile();
                File[] files = liferayHome.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return dir.equals(liferayHome) && name.endsWith("-ext.properties");
                    }
                });
                ArrayList<PropertiesFile> newFiles = new ArrayList<PropertiesFile>();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    newFiles.add(new PropertiesFile(file));
                    ++n2;
                }
                propertiesFiles = newFiles.toArray(new PropertiesFile[0]);
                this.propertiesFilesMap.put(server.getId(), (PropertiesFile[])propertiesFiles);
            }
            if (!CoreUtil.isNullOrEmpty((Object[])propertiesFiles)) {
                Object[] objectArray = propertiesFiles;
                int n = propertiesFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    Object propertiesFile = objectArray[n3];
                    currentChildren.add(propertiesFile);
                    ++n3;
                }
            }
        }
    }

    public boolean hasChildren(Object element) {
        IServer server;
        boolean retval = false;
        if (element instanceof IServer && ServerUtil.isLiferayRuntime((IServer)(server = (IServer)element))) {
            retval = true;
        }
        return retval;
    }

    public boolean hasPipelinedChildren(Object element, boolean currentHasChildren) {
        return this.hasChildren(element);
    }

    private boolean shouldAddChildren(Object parent) {
        IServer server;
        ILiferayServer liferayServer;
        return parent instanceof IServer && !((liferayServer = (ILiferayServer)(server = (IServer)parent).loadAdapter(ILiferayServer.class, null)) instanceof IRemoteServer);
    }
}

