/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenUtil {
    private static final Pattern MAJOR_MINOR_VERSION = Pattern.compile("([0-9]\\.[0-9])\\..*");

    public static Node createNewLiferayProfileNode(Document pomDocument, NewLiferayProfile newLiferayProfile) {
        Element newNode = null;
        String liferayVersion = (String)newLiferayProfile.getLiferayVersion().content();
        try {
            String runtimeName = (String)newLiferayProfile.getRuntimeName().content();
            ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)ServerUtil.getRuntime((String)runtimeName));
            Element root = pomDocument.getDocumentElement();
            Element profiles = NodeUtil.findChildElement((Element)root, (String)"profiles");
            if (profiles == null) {
                newNode = profiles = NodeUtil.appendChildElement((Element)root, (String)"profiles");
            }
            Element newProfile = null;
            if (profiles != null) {
                NodeUtil.appendTextNode((Element)profiles, (String)"\n");
                newProfile = NodeUtil.appendChildElement((Element)profiles, (String)"profile");
                NodeUtil.appendTextNode((Element)profiles, (String)"\n");
                if (newNode == null) {
                    newNode = newProfile;
                }
            }
            if (newProfile != null) {
                IPath autoDeployDir = liferayRuntime.getAppServerDir().removeLastSegments(1).append("deploy");
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                NodeUtil.appendChildElement((Element)newProfile, (String)"id", (String)((String)newLiferayProfile.getId().content()));
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                Element propertiesElement = NodeUtil.appendChildElement((Element)newProfile, (String)"properties");
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.version", (String)liferayVersion);
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.maven.plugin.version", (String)liferayVersion);
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.auto.deploy.dir", (String)autoDeployDir.toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.deploy.dir", (String)liferayRuntime.getAppServerDeployDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.lib.global.dir", (String)liferayRuntime.getAppServerLibGlobalDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.portal.dir", (String)liferayRuntime.getAppServerPortalDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t");
                NodeFormatter formatter = new NodeFormatter();
                formatter.format((Node)newNode);
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Unable to add new liferay profile.", e);
        }
        return newNode;
    }

    public static IStatus executeGoals(IMavenProjectFacade facade, IMavenExecutionContext context, List<String> goals, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        MavenProject mavenProject = facade.getMavenProject(monitor);
        MavenExecutionPlan plan = maven.calculateExecutionPlan(mavenProject, goals, true, monitor);
        List mojos = plan.getMojoExecutions();
        ResolverConfiguration configuration = facade.getResolverConfiguration();
        configuration.setResolveWorkspaceProjects(true);
        for (MojoExecution mojo : mojos) {
            maven.execute(mavenProject, mojo, monitor);
        }
        return Status.OK_STATUS;
    }

    public static IStatus executeMojoGoal(IMavenProjectFacade facade, IMavenExecutionContext context, String goal, IProgressMonitor monitor) throws CoreException {
        List exceptions;
        IStatus retval = null;
        IMaven maven = MavenPlugin.getMaven();
        List<String> goals = Collections.singletonList(goal);
        MavenProject mavenProject = facade.getMavenProject(monitor);
        MavenExecutionPlan plan = maven.calculateExecutionPlan(mavenProject, goals, true, monitor);
        MojoExecution liferayMojoExecution = MavenUtil.getExecution(plan, "liferay-maven-plugin");
        if (liferayMojoExecution != null) {
            ResolverConfiguration configuration = facade.getResolverConfiguration();
            configuration.setResolveWorkspaceProjects(true);
            maven.execute(mavenProject, liferayMojoExecution, monitor);
        }
        if ((exceptions = context.getSession().getResult().getExceptions()).size() == 1) {
            retval = LiferayMavenCore.createErrorStatus((Throwable)exceptions.get(0));
        } else if (exceptions.size() > 1) {
            ArrayList<IStatus> statues = new ArrayList<IStatus>();
            for (Throwable t : exceptions) {
                statues.add(LiferayMavenCore.createErrorStatus(t));
            }
            IStatus firstStatus = (IStatus)statues.get(0);
            retval = new MultiStatus("com.liferay.ide.maven.core", 4, statues.toArray(new IStatus[0]), firstStatus.getMessage(), firstStatus.getException());
        }
        return retval == null ? Status.OK_STATUS : retval;
    }

    public static MojoExecution getExecution(MavenExecutionPlan plan, String artifactId) {
        if (plan != null) {
            for (MojoExecution execution : plan.getMojoExecutions()) {
                if (!artifactId.equals(execution.getArtifactId())) continue;
                return execution;
            }
        }
        return null;
    }

    public static IFolder getGeneratedThemeResourcesFolder(MavenProject mavenProject, IProject project) {
        IPath m2eLiferayFolder = MavenUtil.getM2eLiferayFolder(mavenProject, project);
        return project.getFolder(m2eLiferayFolder).getFolder("theme-resources");
    }

    public static Plugin getPlugin(IMavenProjectFacade facade, String pluginKey, IProgressMonitor monitor) throws CoreException {
        Plugin retval = null;
        boolean loadedParent = false;
        MavenProject mavenProject = facade.getMavenProject(monitor);
        if (mavenProject != null) {
            retval = mavenProject.getPlugin(pluginKey);
        }
        if (retval == null) {
            MavenProject parent = mavenProject.getParent();
            if (parent == null) {
                try {
                    if (MavenUtil.loadParentHierarchy(facade, monitor)) {
                        loadedParent = true;
                    }
                }
                catch (CoreException e) {
                    LiferayMavenCore.logError("Error loading parent hierarchy", e);
                }
            }
            while (parent != null && retval == null) {
                retval = parent.getPlugin(pluginKey);
                parent = parent.getParent();
            }
        }
        if (loadedParent) {
            mavenProject.setParent(null);
        }
        return retval;
    }

    public static Xpp3Dom getLiferayMavenPluginConfig(MavenProject mavenProject) {
        Plugin plugin;
        Xpp3Dom retval = null;
        if (mavenProject != null && (plugin = mavenProject.getPlugin("com.liferay.maven.plugins:liferay-maven-plugin")) != null) {
            retval = (Xpp3Dom)plugin.getConfiguration();
        }
        return retval;
    }

    public static String getLiferayMavenPluginConfig(MavenProject mavenProject, String childElement) {
        Xpp3Dom childNode;
        String retval = null;
        Xpp3Dom liferayMavenPluginConfig = MavenUtil.getLiferayMavenPluginConfig(mavenProject);
        if (liferayMavenPluginConfig != null && (childNode = liferayMavenPluginConfig.getChild(childElement)) != null) {
            retval = childNode.getValue();
        }
        return retval;
    }

    public static String getLiferayMavenPluginType(MavenProject mavenProject) {
        String pluginType = MavenUtil.getLiferayMavenPluginConfig(mavenProject, "pluginType");
        if (pluginType == null) {
            pluginType = "portlet";
        }
        return pluginType;
    }

    public static String getLocalRepositoryDir() {
        String retval = null;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        String userSettings = mavenConfiguration.getUserSettingsFile();
        if (userSettings == null || userSettings.length() == 0) {
            userSettings = MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        }
        MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
        String globalSettings = runtimeManager.getGlobalSettingsFile();
        IMaven maven = MavenPlugin.getMaven();
        try {
            Settings settings = maven.buildSettings(globalSettings, userSettings);
            retval = settings.getLocalRepository();
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get local repository dir.", e);
        }
        if (retval == null) {
            retval = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return retval;
    }

    public static IPath getM2eLiferayFolder(MavenProject mavenProject, IProject project) {
        String buildOutputDir = mavenProject.getBuild().getDirectory();
        String relativeBuildOutputDir = ProjectUtils.getRelativePath((IProject)project, (String)buildOutputDir);
        return new Path(relativeBuildOutputDir).append("m2e-liferay");
    }

    public static String getMajorMinorVersionOnly(String version) {
        String retval = null;
        Matcher matcher = MAJOR_MINOR_VERSION.matcher(version);
        if (matcher.find()) {
            try {
                retval = new Version(matcher.group(1)).toString();
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public static IMavenProjectFacade getProjectFacade(IProject project) {
        return MavenUtil.getProjectFacade(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IMavenProjectFacade getProjectFacade(IProject project, IProgressMonitor monitor) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IFile pomResource = project.getFile("pom.xml");
        if (pomResource.exists()) {
            return projectManager.create(pomResource, true, monitor);
        }
        return null;
    }

    public static String getVersion(String version) {
        String retval = null;
        DefaultArtifactVersion v = new DefaultArtifactVersion(version);
        retval = String.valueOf(v.getMajorVersion()) + "." + v.getMinorVersion() + "." + v.getIncrementalVersion();
        if ("0.0.0".equals(retval)) {
            retval = v.getQualifier();
        }
        try {
            Version.parseVersion((String)retval);
        }
        catch (Exception exception) {
            retval = "0.0.0";
        }
        return retval;
    }

    public static String getWarSourceDirectory(IMavenProjectFacade facade) {
        String retval = null;
        try {
            MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
            IProject project = facade.getProject();
            retval = new WarPluginConfiguration(mavenProject, project).getWarSourceDirectory();
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get war source directory", e);
        }
        return retval;
    }

    public static boolean isMavenProject(IProject project) throws CoreException {
        return project != null && project.exists() && project.isAccessible() && (project.hasNature("org.eclipse.m2e.core.maven2Nature") || project.getFile("pom.xml").exists());
    }

    public static boolean isPomFile(IFile pomFile) {
        return pomFile != null && pomFile.exists() && "pom.xml".equals(pomFile.getName()) && pomFile.getParent() instanceof IProject;
    }

    public static boolean loadParentHierarchy(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        boolean loadedParent = false;
        MavenProject mavenProject = facade.getMavenProject(monitor);
        try {
            if (mavenProject.getModel().getParent() == null || mavenProject.getParent() != null) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        while (mavenProject != null && mavenProject.getModel().getParent() != null) {
            if (monitor.isCanceled()) break;
            MavenProject parentProject = MavenPlugin.getMaven().resolveParentProject(mavenProject, monitor);
            if (parentProject != null) {
                mavenProject.setParent(parentProject);
                loadedParent = true;
            }
            mavenProject = parentProject;
        }
        return loadedParent;
    }

    public static void setConfigValue(Xpp3Dom configuration, String childName, Object value) {
        Xpp3Dom childNode = configuration.getChild(childName);
        if (childNode == null) {
            childNode = new Xpp3Dom(childName);
            configuration.addChild(childNode);
        }
        childNode.setValue(value == null ? null : value.toString());
    }
}

