/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.snippets.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.ui.util.SWTUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class AbstractModelWizardPage
extends NewTypeWizardPage {
    protected static final int IDX_DESELECT = 1;
    protected static final int IDX_SELECT = 0;
    protected IEditorPart editorPart;
    protected String lastVarName = "";
    protected StringButtonDialogField modelClassDialogField;
    protected CheckedListDialogField propertyListField;
    protected Label varNameLabel;
    protected Text varNameText;

    public static Object[] getTypeProperties(IType type) {
        if (type == null) {
            return null;
        }
        JDTBeanIntrospector beanIntrospector = new JDTBeanIntrospector(type);
        Map properties = beanIntrospector.getProperties();
        return properties.keySet().toArray();
    }

    public AbstractModelWizardPage(String pageName, IEditorPart editor) {
        super(true, pageName);
        this.editorPart = editor;
        TypeFieldAdapter adapter = new TypeFieldAdapter();
        this.modelClassDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.modelClassDialogField.setLabelText(Msgs.modelClassLabel);
        this.modelClassDialogField.setButtonLabel(Msgs.newTypeWizardPage_superclass_button);
        String[] buttonLabels = new String[]{Msgs.selectAllLabel, Msgs.deselectAllLabel};
        this.propertyListField = new CheckedListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)new LabelProvider());
        this.propertyListField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.propertyListField.setLabelText(Msgs.propertyColumnsLabel);
        this.propertyListField.setCheckAllButtonIndex(0);
        this.propertyListField.setUncheckAllButtonIndex(1);
    }

    public void createControl(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        this.modelClassDialogField.doFillIntoGrid(topComposite, 3);
        this.propertyListField.doFillIntoGrid(topComposite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.propertyListField.getLabelControl(null), (int)1);
        LayoutUtil.setWidthHint((Control)this.propertyListField.getLabelControl(null), (int)this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing((Control)this.propertyListField.getListControl(null));
        this.propertyListField.getTableViewer().setComparator(new ViewerComparator());
        this.varNameLabel = new Label(topComposite, 16384);
        this.varNameLabel.setText(Msgs.variableNameLabel);
        this.varNameLabel.setLayoutData((Object)new GridData(256));
        this.varNameText = new Text(topComposite, 2052);
        this.varNameText.setLayoutData((Object)new GridData(768));
        this.varNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractModelWizardPage.this.lastVarName = AbstractModelWizardPage.this.varNameText.getText();
            }
        });
        this.setControl((Control)topComposite);
    }

    public IJavaProject getJavaProject() {
        IEditorInput editorInput;
        IJavaProject javaProject = null;
        if (this.editorPart != null && (editorInput = this.editorPart.getEditorInput()) instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            return JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    public String getModel() {
        try {
            IType type = this.getJavaProject().findType(this.getModelClass());
            return type.getElementName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getModelClass() {
        return this.modelClassDialogField.getText();
    }

    public String[] getPropertyColumns() {
        return this.propertyListField.getCheckedElements().toArray(new String[0]);
    }

    public String getTypeName() {
        return this.modelClassDialogField.getText();
    }

    public String getVarName() {
        return this.lastVarName;
    }

    protected IType chooseClass() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{project};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 10);
        dialog.setTitle(Msgs.modelClassSelection);
        dialog.setMessage(Msgs.newTypeWizardPage_SuperClassDialog_message);
        dialog.setInitialPattern(this.getSuperClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void handleBrowseButtonPressed() {
    }

    protected void typeChangeControlPressed(DialogField field) {
        IType type = this.chooseClass();
        if (type != null) {
            this.modelClassDialogField.setText(SuperInterfaceSelectionDialog.getNameWithTypeParameters((IType)type));
            this.updatePropertyList(type);
        }
    }

    protected void updatePropertyList(IType type) {
        ArrayList<Object> propNames = new ArrayList<Object>();
        Object[] props = AbstractModelWizardPage.getTypeProperties(type);
        if (!CoreUtil.isNullOrEmpty((Object[])props)) {
            propNames.addAll(Arrays.asList(props));
        }
        try {
            if (type.isInterface()) {
                Object[] superInterfaces = type.getSuperInterfaceNames();
                if (!CoreUtil.isNullOrEmpty((Object[])superInterfaces)) {
                    Object[] objectArray = superInterfaces;
                    int n = superInterfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object superInterface = objectArray[n2];
                        IType superInterfaceType = type.getJavaProject().findType((String)superInterface);
                        Object[] superInterfaceProps = AbstractModelWizardPage.getTypeProperties(superInterfaceType);
                        if (!CoreUtil.isNullOrEmpty((Object[])superInterfaceProps)) {
                            propNames.addAll(Arrays.asList(superInterfaceProps));
                        }
                        ++n2;
                    }
                }
            } else {
                IType superType = type.getJavaProject().findType(type.getSuperclassName());
                Object[] superTypeProps = AbstractModelWizardPage.getTypeProperties(superType);
                if (!CoreUtil.isNullOrEmpty((Object[])superTypeProps)) {
                    propNames.addAll(Arrays.asList(superTypeProps));
                }
            }
        }
        catch (Exception exception) {}
        this.propertyListField.setElements(propNames);
        this.varNameText.setText("a" + this.getModel());
    }

    private static class Msgs
    extends NLS {
        public static String deselectAllLabel;
        public static String modelClassLabel;
        public static String modelClassSelection;
        public static String newTypeWizardPage_superclass_button;
        public static String newTypeWizardPage_SuperClassDialog_message;
        public static String propertyColumnsLabel;
        public static String selectAllLabel;
        public static String variableNameLabel;

        static {
            Msgs.initializeMessages((String)AbstractModelWizardPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    protected class TypeFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        protected TypeFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            AbstractModelWizardPage.this.typeChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void selectionChanged(ListDialogField field) {
        }
    }
}

