/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.net.URL;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class UrlJumpActionHandler
extends JumpActionHandler {
    public static final String ID = "Sapphire.Jump.URL";

    public UrlJumpActionHandler() {
        this.setId(ID);
    }

    @Override
    protected boolean computeEnablementState() {
        if (super.computeEnablementState()) {
            Value value = (Value)this.property();
            return value.validation().severity() != Status.Severity.ERROR;
        }
        return false;
    }

    @Override
    protected Object run(Presentation context) {
        URL url = (URL)((Value)this.property()).content();
        if (url != null) {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(url);
            }
            catch (PartInitException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        return null;
    }
}

