/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp.templates;

import com.google.common.collect.ComparisonChain;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.internal.calls.rcp.templates.PatternRecommendation;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTemplateProposal
extends TemplateProposal
implements Comparable<JavaTemplateProposal> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private PatternRecommendation recommendation;

    public JavaTemplateProposal(Template template, DocumentTemplateContext context, Image image, PatternRecommendation recommendation) {
        super(template, (TemplateContext)context, JavaTemplateProposal.calculateReplacementRegion(context), image);
        this.recommendation = recommendation;
        this.computeStyledDisplayString();
        this.setRelevance(this.getRelevance() + Recommendations.asPercentage((Recommendation)recommendation));
    }

    private static IRegion calculateReplacementRegion(DocumentTemplateContext context) {
        return new Region(context.getCompletionOffset(), context.getCompletionLength());
    }

    private void computeStyledDisplayString() {
        StyledString styledString = new StyledString();
        styledString.append(String.format("dynamic '%s'", this.getTemplate().getDescription()));
        styledString.append(" - ", StyledString.QUALIFIER_STYLER);
        styledString.append(this.getTemplate().getName().replace("pattern", "Pattern #"), StyledString.QUALIFIER_STYLER);
        styledString.append(String.format(" - %d %%", Recommendations.asPercentage((Recommendation)this.recommendation)), StyledString.COUNTER_STYLER);
        this.setDisplayString(styledString);
    }

    @Override
    public int compareTo(JavaTemplateProposal o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.recommendation.getType().getClassName()), (Comparable)((Object)o.recommendation.getType().getClassName())).compare(this.recommendation.getRelevance(), o.recommendation.getRelevance()).result();
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                String className = this.recommendation.getType().getClassName();
                return StringUtils.startsWithIgnoreCase((CharSequence)className, (CharSequence)content);
            }
        }
        catch (BadLocationException e) {
            this.log.error("Failed to validate template", (Throwable)e);
        }
        return false;
    }
}

