/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import java.io.File;

public class BinaryProjectRecord {
    private String binaryName;
    private File binaryFile;
    private String displayName;
    private String filePath;
    private String liferayVersion;
    boolean conflicts;
    boolean isHook;
    boolean isTheme;
    boolean isPortlet;
    boolean isLayoutTpl;
    boolean isExt;
    boolean isWeb;

    public BinaryProjectRecord(File binaryFile) {
        this.binaryFile = binaryFile;
        this.setNames();
    }

    private void setNames() {
        if (this.binaryFile != null) {
            this.binaryName = this.binaryFile.getName();
            this.filePath = this.binaryFile.getAbsolutePath();
            this.setPluginProperties();
        }
    }

    private void setPluginProperties() {
        if (this.binaryName != null) {
            int index = -1;
            if (this.binaryName.contains("-hook")) {
                index = this.binaryName.indexOf("-hook");
                this.isHook = index != -1;
            } else if (this.binaryName.contains("-theme")) {
                index = this.binaryName.indexOf("-theme");
                this.isTheme = index != -1;
            } else if (this.binaryName.contains("-portlet")) {
                index = this.binaryName.indexOf("-portlet");
                this.isPortlet = index != -1;
            } else if (this.binaryName.contains("-layouttpl")) {
                index = this.binaryName.indexOf("-layouttpl");
                this.isLayoutTpl = index != -1;
            } else if (this.binaryName.contains("-ext")) {
                index = this.binaryName.indexOf("-ext");
                this.isExt = index != -1;
            } else if (this.binaryName.contains("-web")) {
                index = this.binaryName.indexOf("-web");
                boolean bl = this.isWeb = index != -1;
            }
            if (index != -1) {
                this.displayName = this.binaryName.substring(0, index);
            }
            if ((index = this.binaryName.lastIndexOf("-")) != -1) {
                this.liferayVersion = this.binaryName.substring(index + 1, this.binaryName.lastIndexOf("."));
            }
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String label) {
        this.filePath = label;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
    }

    public File getBinaryFile() {
        return this.binaryFile;
    }

    public void setBinaryFile(File binaryFile) {
        this.binaryFile = binaryFile;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String liferayPluginName) {
        this.displayName = liferayPluginName;
    }

    public boolean isConflicts() {
        return this.conflicts;
    }

    public void setConflicts(boolean hasConflicts) {
        this.conflicts = hasConflicts;
    }

    public String getLiferayVersion() {
        return this.liferayVersion;
    }

    public boolean isHook() {
        return this.isHook;
    }

    public boolean isTheme() {
        return this.isTheme;
    }

    public boolean isPortlet() {
        return this.isPortlet;
    }

    public boolean isLayoutTpl() {
        return this.isLayoutTpl;
    }

    public boolean isWeb() {
        return this.isWeb;
    }

    public String getLiferayPluginName() {
        if (this.isHook) {
            return String.valueOf(this.getDisplayName()) + "-hook";
        }
        if (this.isLayoutTpl) {
            return String.valueOf(this.getDisplayName()) + "-layouttpl";
        }
        if (this.isPortlet) {
            return String.valueOf(this.getDisplayName()) + "-portlet";
        }
        if (this.isTheme) {
            return String.valueOf(this.getDisplayName()) + "-theme";
        }
        if (this.isExt) {
            return String.valueOf(this.getDisplayName()) + "-ext";
        }
        if (this.isWeb) {
            return String.valueOf(this.getDisplayName()) + "-web";
        }
        return null;
    }

    public boolean isExt() {
        return this.isExt;
    }
}

