/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

public class BinaryProjectsImportOperation
extends AbstractDataModelOperation
implements ISDKProjectsImportDataModelProperties {
    public BinaryProjectsImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        final String sdkLocation = this.model.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        final IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        final Object[] projects = (Object[])this.model.getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        final BridgedRuntime bridgedRuntime = (BridgedRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        WorkspaceJob job = new WorkspaceJob(Msgs.importingBinaryProjectPlugins){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (projects != null) {
                    SDKManager sdkManager = SDKManager.getInstance();
                    SDK liferaySDK = sdkManager.getSDK((IPath)new Path(sdkLocation));
                    Object[] seleBinaryRecords = projects;
                    monitor.beginTask(Msgs.creatingSDKProjects, seleBinaryRecords.length);
                    Object[] projectRecords = new ProjectRecord[seleBinaryRecords.length];
                    int i = 0;
                    while (i < seleBinaryRecords.length) {
                        BinaryProjectRecord pluginBinaryRecord = (BinaryProjectRecord)seleBinaryRecords[i];
                        try {
                            monitor.subTask(String.valueOf(Msgs.creatingPlugin) + pluginBinaryRecord.getLiferayPluginName());
                            projectRecords[i] = ProjectImportUtil.createSDKPluginProject(bridgedRuntime, pluginBinaryRecord, liferaySDK);
                            monitor.worked(1);
                        }
                        catch (IOException e) {
                            throw new CoreException(ProjectCore.createErrorStatus("Error creating project.", e));
                        }
                        ++i;
                    }
                    monitor.done();
                    ProjectImportUtil.createWorkspaceProjects(projectRecords, runtime, sdkLocation, monitor);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String creatingPlugin;
        public static String creatingSDKProjects;
        public static String importingBinaryProjectPlugins;

        static {
            Msgs.initializeMessages((String)BinaryProjectsImportOperation.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

