/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ComponentUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class PluginClasspathContainer
implements IClasspathContainer {
    protected static final Collection<String> portalSourceJars = Arrays.asList("util-bridges.jar", "util-java.jar", "util-taglib.jar", "portal-impl.jar");
    protected static ClasspathDecorationsManager cpDecorations = new ClasspathDecorationsManager("com.liferay.ide.server.core");
    protected static final String SEPARATOR = "!";
    protected IClasspathEntry[] classpathEntries;
    protected IJavaProject javaProject;
    protected IPath path;
    protected IPath pluginPackageFilePath;
    protected IPath portalDir;
    protected String javadocURL;
    protected IPath sourceLocation;

    public static String getDecorationManagerKey(IProject project, String container) {
        return String.valueOf(project.getName()) + SEPARATOR + container;
    }

    static ClasspathDecorationsManager getDecorationsManager() {
        return cpDecorations;
    }

    public PluginClasspathContainer(IPath containerPath, IJavaProject project, IPath portalDir, String javadocURL, IPath sourceURL) {
        this.path = containerPath;
        this.javaProject = project;
        this.portalDir = portalDir;
        this.javadocURL = javadocURL;
        this.sourceLocation = sourceURL;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.classpathEntries == null) {
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            if (this.portalDir != null) {
                String[] stringArray = this.getPortalJars();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pluginJar = stringArray[n2];
                    entries.add(this.createPortalJarClasspathEntry(pluginJar));
                    ++n2;
                }
                stringArray = this.getPortalDependencyJars();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String pluginPackageJar = stringArray[n2];
                    entries.add(this.createPortalJarClasspathEntry(pluginPackageJar));
                    ++n2;
                }
            }
            this.classpathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
        }
        return this.classpathEntries;
    }

    public abstract String getDescription();

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getPortalDir() {
        return this.portalDir;
    }

    public String getJavadocURL() {
        return this.javadocURL;
    }

    public IPath getSourceLocation() {
        return this.sourceLocation;
    }

    protected IClasspathEntry createClasspathEntry(IPath entryPath, IPath sourcePath) {
        return this.createClasspathEntry(entryPath, sourcePath, null);
    }

    protected IClasspathEntry createClasspathEntry(IPath entryPath, IPath sourceLocation, String javadocURL) {
        IPath sourceRootPath = null;
        IPath sourcePath = null;
        IAccessRule[] rules = new IAccessRule[]{};
        Object[] attrs = new IClasspathAttribute[]{};
        ClasspathDecorations dec = cpDecorations.getDecorations(PluginClasspathContainer.getDecorationManagerKey(this.javaProject.getProject(), this.getPath().toString()), entryPath.toString());
        if (dec != null) {
            sourcePath = dec.getSourceAttachmentPath();
            sourceRootPath = dec.getSourceAttachmentRootPath();
            attrs = dec.getExtraAttributes();
        }
        if (javadocURL != null) {
            if (CoreUtil.empty((Object[])attrs)) {
                attrs = new IClasspathAttribute[]{this.newJavadocAttr(javadocURL)};
            } else {
                ArrayList<Object> newAttrs = new ArrayList<Object>();
                Object[] objectArray = attrs;
                int n = attrs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object attr = objectArray[n2];
                    if ("javadoc_location".equals(attr.getName())) {
                        newAttrs.add(this.newJavadocAttr(javadocURL));
                    } else {
                        newAttrs.add(attr);
                    }
                    ++n2;
                }
                attrs = newAttrs.toArray(new IClasspathAttribute[0]);
            }
        }
        if (sourcePath == null && sourceLocation != null) {
            sourcePath = sourceLocation;
        }
        return JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourcePath, (IPath)sourceRootPath, (IAccessRule[])rules, (IClasspathAttribute[])attrs, (boolean)false);
    }

    protected IClasspathAttribute newJavadocAttr(String javadocURL) {
        return JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocURL);
    }

    protected IClasspathEntry createContextClasspathEntry(String context) {
        String type;
        IProject project;
        SDK sdk;
        IPath sdkLocation;
        IPath serviceJarPath;
        IClasspathEntry entry = null;
        IFile serviceJar = ComponentUtil.findServiceJarForContext((String)context);
        if (serviceJar.exists()) {
            IFolder defaultDocroot;
            IFolder serviceFolder;
            IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)serviceJar.getProject());
            if (webproject != null && webproject.getDefaultDocrootFolder() != null && (serviceFolder = (defaultDocroot = webproject.getDefaultDocrootFolder()).getFolder((IPath)new Path("WEB-INF/service"))).exists()) {
                entry = this.createClasspathEntry(serviceJar.getLocation(), serviceFolder.getLocation());
            }
            if (entry == null) {
                entry = this.createClasspathEntry(serviceJar.getLocation(), null);
            }
        }
        if (entry == null && (serviceJarPath = (sdkLocation = (sdk = SDKUtil.getSDK((IProject)(project = this.javaProject.getProject()))).getLocation()).append(type = ProjectUtil.isPortletProject(project) ? "portlets" : (ProjectUtil.isHookProject(project) ? "hooks" : (ProjectUtil.isExtProject(project) ? "ext" : ""))).append(context).append("docroot/WEB-INF/lib").append(String.valueOf(context) + "-service.jar")).toFile().exists()) {
            IPath servicePath = serviceJarPath.removeLastSegments(2).append("service");
            entry = this.createClasspathEntry(serviceJarPath, (IPath)(servicePath.toFile().exists() ? servicePath : null));
        }
        return entry;
    }

    protected IClasspathEntry createPortalJarClasspathEntry(String portalJar) {
        IPath entryPath = this.portalDir.append("/WEB-INF/lib/" + portalJar);
        IPath sourcePath = null;
        if (portalSourceJars.contains(portalJar)) {
            sourcePath = this.getSourceLocation();
        }
        return this.createClasspathEntry(entryPath, sourcePath, this.javadocURL);
    }

    protected IClasspathEntry findSuggestedEntry(IPath jarPath, IClasspathEntry[] suggestedEntries) {
        if (jarPath != null && !CoreUtil.isNullOrEmpty((String)jarPath.toString()) && !CoreUtil.isNullOrEmpty((Object[])suggestedEntries)) {
            int matchLength = jarPath.segmentCount();
            IClasspathEntry[] iClasspathEntryArray = suggestedEntries;
            int n = suggestedEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry suggestedEntry = iClasspathEntryArray[n2];
                IPath suggestedPath = suggestedEntry.getPath();
                IPath pathToMatch = suggestedPath.removeFirstSegments(suggestedPath.segmentCount() - matchLength).setDevice(null).makeAbsolute();
                if (jarPath.equals((Object)pathToMatch)) {
                    return suggestedEntry;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IFile getPluginPackageFile() {
        IFile retval = null;
        if (this.pluginPackageFilePath == null) {
            retval = this.lookupPluginPackageFile();
            if (retval != null && retval.exists()) {
                this.pluginPackageFilePath = retval.getFullPath();
                return retval;
            }
        } else {
            retval = ResourcesPlugin.getWorkspace().getRoot().getFile(this.pluginPackageFilePath);
            if (!retval.exists()) {
                this.pluginPackageFilePath = null;
                retval = this.lookupPluginPackageFile();
            }
        }
        return retval;
    }

    protected String[] getPortalDependencyJars() {
        String[] jars = new String[]{};
        IFile pluginPackageFile = this.getPluginPackageFile();
        try {
            String deps = this.getPropertyValue("portal-dependency-jars", pluginPackageFile);
            String[] split = deps.split(",");
            if (split.length > 0 && !CoreUtil.isNullOrEmpty((String)split[0])) {
                int i = 0;
                while (i < split.length) {
                    split[i] = split[i].trim();
                    ++i;
                }
                return split;
            }
        }
        catch (Exception exception) {}
        return jars;
    }

    protected abstract String[] getPortalJars();

    protected String getPropertyValue(String key, IFile propertiesFile) {
        String retval;
        block14: {
            retval = null;
            InputStream contents = null;
            try {
                try {
                    Properties props = new Properties();
                    contents = this.getPluginPackageFile().getContents();
                    props.load(contents);
                    retval = props.getProperty(key, "");
                }
                catch (Exception exception) {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (Exception exception) {}
            }
        }
        return retval;
    }

    protected String[] getRequiredDeploymentContexts() {
        String[] jars = new String[]{};
        IFile pluginPackageFile = this.getPluginPackageFile();
        try {
            String context = this.getPropertyValue("required-deployment-contexts", pluginPackageFile);
            String[] split = context.split(",");
            if (split.length > 0 && !CoreUtil.isNullOrEmpty((String)split[0])) {
                return split;
            }
        }
        catch (Exception exception) {}
        return jars;
    }

    protected IFile lookupPluginPackageFile() {
        IFolder webroot;
        IContainer resource;
        IFile pluginPackageFile = null;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.javaProject.getProject());
        if (comp != null && (resource = comp.getRootFolder().getUnderlyingFolder()) instanceof IFolder && !(pluginPackageFile = (webroot = (IFolder)resource).getFile("WEB-INF/liferay-plugin-package.properties")).exists() && webroot.getFullPath().toPortableString().endsWith("WEB-INF/ext-web/docroot")) {
            IPath parentDocroot = webroot.getFullPath().removeFirstSegments(1).removeLastSegments(3);
            IFolder parentWebroot = this.javaProject.getProject().getFolder(parentDocroot);
            if (parentWebroot.exists()) {
                pluginPackageFile = parentWebroot.getFile("WEB-INF/liferay-plugin-package.properties");
            }
        }
        return pluginPackageFile;
    }
}

