/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.ExtClasspathContainer;
import com.liferay.ide.project.core.HookClasspathContainer;
import com.liferay.ide.project.core.PluginClasspathContainer;
import com.liferay.ide.project.core.PortletClasspathContainer;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ThemeClasspathContainer;
import com.liferay.ide.project.core.WebClasspathContainer;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.util.ServerUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;

public class PluginClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public static final String ID = "com.liferay.ide.eclipse.server.plugin.container";
    protected static final ClasspathDecorationsManager cpDecorations = PluginClasspathContainer.getDecorationsManager();

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        IClasspathContainer classpathContainer = null;
        int count = containerPath.segmentCount();
        if (count != 2) {
            throw new CoreException(ProjectCore.createErrorStatus("Invalid plugin classpath container should expecting 2 segments."));
        }
        String root = containerPath.segment(0);
        if (!ID.equals(root)) {
            throw new CoreException(ProjectCore.createErrorStatus("Invalid plugin classpath container, expecting container root com.liferay.ide.eclipse.server.plugin.container"));
        }
        String finalSegment = containerPath.segment(1);
        IPath portalDir = ServerUtil.getPortalDir((IJavaProject)project);
        if (portalDir == null) {
            return;
        }
        String javadocURL = null;
        IPath sourceLocation = null;
        try {
            ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)project.getProject());
            if (liferayRuntime != null) {
                javadocURL = liferayRuntime.getJavadocURL();
                sourceLocation = liferayRuntime.getSourceLocation();
            }
        }
        catch (Exception e) {
            ProjectCore.logError(e);
        }
        classpathContainer = this.getCorrectContainer(containerPath, finalSegment, project, portalDir, javadocURL, sourceLocation);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, null);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        String key = PluginClasspathContainer.getDecorationManagerKey(project.getProject(), containerPath.toString());
        IClasspathEntry[] entries = containerSuggestion.getClasspathEntries();
        cpDecorations.clearAllDecorations(key);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath srcpath = entry.getSourceAttachmentPath();
            IPath srcrootpath = entry.getSourceAttachmentRootPath();
            IClasspathAttribute[] attrs = entry.getExtraAttributes();
            if (srcpath != null || attrs.length > 0) {
                String eid = entry.getPath().toString();
                ClasspathDecorations dec = new ClasspathDecorations();
                dec.setSourceAttachmentPath(srcpath);
                dec.setSourceAttachmentRootPath(srcrootpath);
                dec.setExtraAttributes(attrs);
                cpDecorations.setDecorations(key, eid, dec);
            }
            ++i;
        }
        cpDecorations.save();
        IPath portalDir = null;
        String javadocURL = null;
        IPath sourceLocation = null;
        if (containerSuggestion instanceof PluginClasspathContainer) {
            portalDir = ((PluginClasspathContainer)containerSuggestion).getPortalDir();
            javadocURL = ((PluginClasspathContainer)containerSuggestion).getJavadocURL();
            sourceLocation = ((PluginClasspathContainer)containerSuggestion).getSourceLocation();
        } else {
            portalDir = ServerUtil.getPortalDir((IJavaProject)project);
            try {
                ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)project.getProject());
                if (liferayRuntime != null) {
                    javadocURL = liferayRuntime.getJavadocURL();
                    sourceLocation = liferayRuntime.getSourceLocation();
                }
            }
            catch (Exception e) {
                ProjectCore.logError(e);
            }
        }
        if (portalDir != null) {
            IClasspathContainer newContainer = this.getCorrectContainer(containerPath, containerPath.segment(1), project, portalDir, javadocURL, sourceLocation);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{newContainer}, null);
        }
    }

    protected IClasspathContainer getCorrectContainer(IPath containerPath, String finalSegment, IJavaProject project, IPath portalDir, String javadocURL, IPath sourceURL) throws CoreException {
        PluginClasspathContainer classpathContainer = null;
        if ("portlet".equals(finalSegment)) {
            classpathContainer = new PortletClasspathContainer(containerPath, project, portalDir, javadocURL, sourceURL);
        } else if ("hook".equals(finalSegment)) {
            classpathContainer = new HookClasspathContainer(containerPath, project, portalDir, javadocURL, sourceURL);
        } else if ("ext".equals(finalSegment)) {
            classpathContainer = new ExtClasspathContainer(containerPath, project, portalDir, javadocURL, sourceURL);
        } else if ("theme".equals(finalSegment)) {
            classpathContainer = new ThemeClasspathContainer(containerPath, project, portalDir, javadocURL, sourceURL);
        } else if ("web".equals(finalSegment)) {
            classpathContainer = new WebClasspathContainer(containerPath, project, portalDir, javadocURL, sourceURL);
        } else {
            throw new CoreException(LiferayServerCore.error((String)("Invalid final segment of type: " + finalSegment)));
        }
        return classpathContainer;
    }
}

