/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.FlexibleProject;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.PluginsSDKPortal;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.SDKProjectBuilder;
import com.liferay.ide.project.core.SDKProjectRemoteServerPublisher;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.remote.IRemoteServerPublisher;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginsSDKRuntimeProject
extends FlexibleProject
implements IWebProject {
    private ILiferayRuntime liferayRuntime;

    public PluginsSDKRuntimeProject(IProject project, ILiferayRuntime liferayRuntime) {
        super(project);
        this.liferayRuntime = liferayRuntime;
    }

    public <T> T adapt(Class<T> adapterType) {
        Object adapter = super.adapt(adapterType);
        if (adapter != null) {
            return (T)adapter;
        }
        if (IProjectBuilder.class.equals(adapterType)) {
            SDK sdk = this.getSDK();
            if (sdk != null) {
                SDKProjectBuilder projectBuilder = new SDKProjectBuilder(this.getProject(), sdk);
                return adapterType.cast(projectBuilder);
            }
        } else if (IRemoteServerPublisher.class.equals(adapterType)) {
            SDK sdk = this.getSDK();
            if (sdk != null) {
                SDKProjectRemoteServerPublisher remotePublisher = new SDKProjectRemoteServerPublisher(this.getProject(), sdk);
                return adapterType.cast((Object)remotePublisher);
            }
        } else if (ILiferayPortal.class.equals(adapterType)) {
            PluginsSDKPortal portal = new PluginsSDKPortal(this.liferayRuntime);
            return adapterType.cast(portal);
        }
        return null;
    }

    public IPath getLibraryPath(String filename) {
        Object[] libs = this.getUserLibs();
        if (!CoreUtil.isNullOrEmpty((Object[])libs)) {
            Object[] objectArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                Object lib = objectArray[n2];
                if (lib.lastSegment().startsWith(filename)) {
                    return lib;
                }
                ++n2;
            }
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String retval = defaultValue;
        if (("theme.type".equals(key) || "theme.parent".equals(key)) && ProjectUtil.isThemeProject(this.getProject())) {
            try {
                Document buildXmlDoc = FileUtil.readXML((InputStream)this.getProject().getFile("build.xml").getContents(), null, null);
                NodeList properties = buildXmlDoc.getElementsByTagName("property");
                int i = 0;
                while (i < properties.getLength()) {
                    Node item = properties.item(i);
                    Node name = item.getAttributes().getNamedItem("name");
                    if (name != null && key.equals(name.getNodeValue())) {
                        Node value = item.getAttributes().getNamedItem("value");
                        retval = value.getNodeValue();
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                ProjectCore.logError("Unable to get property " + key, (Exception)((Object)e));
            }
        }
        return retval;
    }

    protected SDK getSDK() {
        SDK retval = null;
        IPath sdkLocation = this.getProject().getRawLocation().removeLastSegments(2);
        retval = SDKManager.getInstance().getSDK(sdkLocation);
        if (retval == null) {
            retval = SDKUtil.createSDKFromLocation((IPath)sdkLocation);
            SDKManager.getInstance().addSDK(retval);
        }
        return retval;
    }

    public IPath[] getUserLibs() {
        return this.liferayRuntime.getUserLibs();
    }

    public Collection<IFile> getOutputs(boolean build, IProgressMonitor monitor) throws CoreException {
        HashSet<IFile> outputs = new HashSet<IFile>();
        if (build) {
            this.getProject().build(10, monitor);
            SDK sdk = SDKUtil.getSDK((IProject)this.getProject());
            IStatus warStatus = sdk.war(this.getProject(), null, true, monitor);
            warStatus.isOK();
        }
        return outputs;
    }
}

