/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.SDKProjectsImportOperation;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.osgi.framework.Version;

public class SDKProjectsImportDataModelProvider
extends FacetProjectCreationDataModelProvider
implements ISDKProjectsImportDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new SDKProjectsImportOperation(this.model);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(propertyName)) {
            String sdkName = this.getStringProperty("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME");
            SDK sdk = SDKManager.getInstance().getSDK(sdkName);
            if (sdk != null) {
                return sdk.getLocation().toOSString();
            }
        } else if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            String sdkLoc = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
            try {
                SDK sdk = SDKUtil.createSDKFromLocation((IPath)new Path(sdkLoc));
                if (sdk != null) {
                    Version v = new Version(sdk.getVersion());
                    return v.toString();
                }
            }
            catch (Exception exception) {}
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SDK_VERSION");
        propertyNames.add("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        return propertyNames;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME".equals(propertyName)) {
            SDK[] validSDKs = SDKManager.getInstance().getSDKs();
            Object[] values = null;
            String[] descriptions = null;
            if (validSDKs.length == 0) {
                values = new String[]{"__NO__SDK__"};
                descriptions = new String[]{"<None>"};
            } else {
                values = new String[validSDKs.length];
                descriptions = new String[validSDKs.length];
                int i = 0;
                while (i < validSDKs.length) {
                    values[i] = validSDKs[i].getName();
                    descriptions[i] = validSDKs[i].getName();
                    ++i;
                }
            }
            return DataModelPropertyDescriptor.createDescriptors((Object[])values, (String[])descriptions);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void init() {
        super.init();
        IFacetedProjectWorkingCopy facetedProject = this.getFacetedProjectWorkingCopy();
        facetedProject.setSelectedPreset("liferay.portlet.preset");
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        fixedFacets.add(ProjectFacetsManager.getProjectFacet((String)"liferay.ext"));
        facetedProject.setFixedProjectFacets(Collections.unmodifiableSet(fixedFacets));
        ProjectUtil.setDefaultRuntime(this.getDataModel());
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            return false;
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IStatus validate(String name) {
        if ("ISDKProjectsImportDataModelProperties.SDK_LOCATION".equals(name)) {
            String sdkLocation = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
            if (SDKUtil.isValidSDKLocation((String)sdkLocation)) {
                return Status.OK_STATUS;
            }
            return ProjectCore.createErrorStatus(Msgs.invalidPluginSDKLocation);
        }
        if ("ISDKProjectsImportDataModelProperties.SDK_VERSION".equals(name)) {
            String sdkVersion = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_VERSION");
            if (SDKUtil.isValidSDKVersion((String)sdkVersion, (Version)SDKManager.getLeastValidVersion())) {
                Object runtime = this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                if (this.compareSDKRuntimeVersion(sdkVersion, runtime)) {
                    return Status.OK_STATUS;
                }
                return ProjectCore.createWarningStatus(Msgs.versionUnequal);
            }
            return ProjectCore.createErrorStatus(String.valueOf(Msgs.invalidPluginSDKVersion) + SDKManager.getLeastValidVersion());
        }
        if ("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS".equals(name)) {
            Object[] selectedProjects;
            Object val = this.getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
            if (val instanceof Object[] && (selectedProjects = (Object[])val).length >= 1) {
                Object[] objectArray = selectedProjects;
                int n = selectedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object project = objectArray[n2];
                    if (project instanceof BinaryProjectRecord) {
                        BinaryProjectRecord binaryProject = (BinaryProjectRecord)project;
                        Version sdkVersion = new Version(this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_VERSION"));
                        if (binaryProject.isWeb() && CoreUtil.compareVersions((Version)sdkVersion, (Version)ILiferayConstants.V700) < 0) {
                            return ProjectCore.createErrorStatus(Msgs.unableSupportWebPluginType);
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
            return this.createSelectedProjectsErrorStatus();
        }
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(name)) {
            Object runtime = this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (!(runtime instanceof BridgedRuntime)) {
                return ProjectCore.createErrorStatus(Msgs.selectValidLiferayRuntime);
            }
            String sdkVersion = this.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_VERSION");
            if (this.compareSDKRuntimeVersion(sdkVersion, runtime)) {
                return Status.OK_STATUS;
            }
            return ProjectCore.createWarningStatus(Msgs.versionUnequal);
        }
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(name)) {
            return Status.OK_STATUS;
        }
        return super.validate(name);
    }

    private boolean compareSDKRuntimeVersion(String sdkVersion, Object runtime) {
        if (sdkVersion != null && runtime instanceof BridgedRuntime) {
            try {
                Version liferaySdkVersion = new Version(sdkVersion);
                String runtimeVersion = ServerUtil.getLiferayRuntime((BridgedRuntime)((BridgedRuntime)runtime)).getPortalVersion();
                Version liferayRuntimeVersion = new Version(runtimeVersion);
                if (liferaySdkVersion.getMajor() == liferayRuntimeVersion.getMajor() && liferaySdkVersion.getMinor() == liferayRuntimeVersion.getMinor()) {
                    return true;
                }
            }
            catch (Exception e) {
                LiferayCore.logError((String)"invalid sdk or runtime version ", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public IStatus createSelectedProjectsErrorStatus() {
        return ProjectCore.createErrorStatus(Msgs.selectOneLiferayProject);
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    public IStatus validateSuper(String name) {
        return super.validate(name);
    }

    private static class Msgs
    extends NLS {
        public static String invalidPluginSDKLocation;
        public static String invalidPluginSDKVersion;
        public static String selectOneLiferayProject;
        public static String selectValidLiferayRuntime;
        public static String unableSupportWebPluginType;
        public static String versionUnequal;

        static {
            Msgs.initializeMessages((String)SDKProjectsImportDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

