/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.facet;

import com.liferay.ide.project.core.ProjectCore;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class LiferayFacetedProjectListener
implements IFacetedProjectListener {
    static final String JSDT_FACET = "wst.jsdt.web";

    public void handleEvent(IFacetedProjectEvent event) {
        IProjectFacetActionEvent actionEvent;
        if (event.getType() == IFacetedProjectEvent.Type.POST_INSTALL && JSDT_FACET.equals((actionEvent = (IProjectFacetActionEvent)event).getProjectFacet().getId())) {
            WorkspaceJob uninstall = new WorkspaceJob("uninstall jsdt facet"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFacetedProject fProject = actionEvent.getProject();
                        Set fixedFacets = fProject.getFixedProjectFacets();
                        HashSet<IProjectFacet> updatedFacets = new HashSet<IProjectFacet>();
                        for (IProjectFacet f : fixedFacets) {
                            if (LiferayFacetedProjectListener.JSDT_FACET.equals(f.getId())) continue;
                            updatedFacets.add(f);
                        }
                        fProject.setFixedProjectFacets(updatedFacets);
                    }
                    catch (Exception e) {
                        ProjectCore.logError("Unable to removed fixed jsdt facet", e);
                    }
                    try {
                        IFile name;
                        IFile container;
                        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                        IFacetedProject.Action.Type type = IFacetedProject.Action.Type.valueOf((String)"uninstall");
                        IFacetedProject.Action uninstallJsdt = new IFacetedProject.Action(type, actionEvent.getProjectFacetVersion(), null);
                        actions.add(uninstallJsdt);
                        actionEvent.getProject().modify(actions, monitor);
                        IProject project = actionEvent.getProject().getProject();
                        IFile jsdtscope = project.getFile(".settings/.jsdtscope");
                        if (jsdtscope.exists()) {
                            jsdtscope.delete(true, monitor);
                        }
                        if ((container = project.getFile(".settings/org.eclipse.wst.jsdt.ui.superType.container")).exists()) {
                            container.delete(true, monitor);
                        }
                        if ((name = project.getFile(".settings/org.eclipse.wst.jsdt.ui.superType.name")).exists()) {
                            name.delete(true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        ProjectCore.logError("Unable to uninstall jsdt facet", (Exception)((Object)e));
                    }
                    return Status.OK_STATUS;
                }
            };
            uninstall.schedule();
        }
    }
}

