/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BaseOpMethods;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.ServiceCommand;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class NewLiferayModuleProjectOpMethods
extends BaseOpMethods {
    public static final Status execute(NewLiferayModuleProjectOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay plugin project (this process may take several minutes)", 100);
        Status retval = null;
        try {
            NewLiferayProjectProvider projectProvider = (NewLiferayProjectProvider)op.getProjectProvider().content(true);
            IStatus status = projectProvider.createNewProject(op, monitor);
            retval = StatusBridge.create((IStatus)status);
        }
        catch (Exception e) {
            ProjectCore.logError("Error creating Liferay module project.", e);
            return Status.createErrorStatus((String)"Error creating Liferay module project. Please see Eclipse error log for more details.", (Throwable)e);
        }
        return retval;
    }

    public static String getMavenParentPomGroupId(NewLiferayModuleProjectOp op, String projectName, IPath path) {
        List groupId;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !(groupId = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentGroupId", String.class, new Object[]{parentProjectDir})).isEmpty()) {
            retval = (String)groupId.get(0);
        }
        return retval;
    }

    public static String getMavenParentPomVersion(NewLiferayModuleProjectOp op, String projectName, IPath path) {
        List version;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !(version = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentVersion", String.class, new Object[]{parentProjectDir})).isEmpty()) {
            retval = (String)version.get(0);
        }
        return retval;
    }

    public static void addProperties(File dest, List<String> properties) throws Exception {
        if (properties == null || properties.size() < 1) {
            return;
        }
        FileInputStream fis = new FileInputStream(dest);
        String content = new String(FileUtil.readContents((InputStream)fis));
        fis.close();
        String fontString = content.substring(0, content.indexOf("property"));
        String endString = content.substring(content.indexOf("},") + 2);
        String property = content.substring(content.indexOf("property"), content.indexOf("},"));
        property = property.substring(property.indexOf("{") + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("property = {\n");
        if (!CoreUtil.isNullOrEmpty((String)property)) {
            property = property.substring(1);
            property = property.substring(0, property.lastIndexOf("\t") - 1);
            property = String.valueOf(property) + ",\n";
            sb.append(property);
        }
        for (String str : properties) {
            sb.append("\t\t\"" + str + "\",\n");
        }
        sb.deleteCharAt(sb.toString().length() - 2);
        sb.append("\t},");
        StringBuilder all = new StringBuilder();
        all.append(fontString);
        all.append(sb.toString());
        all.append(endString);
        String newContent = all.toString();
        if (!content.equals(newContent)) {
            FileUtil.writeFileFromStream((File)dest, (InputStream)new ByteArrayInputStream(newContent.getBytes()));
        }
    }

    public static void addDependencies(File file, String bundleId) {
        IServer[] servers;
        IServer runningServer = null;
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getServerState() == 2 && server.getServerType().getId().equals("com.liferay.ide.server.portal")) {
                runningServer = server;
                break;
            }
            ++n2;
        }
        ServiceCommand serviceCommand = new ServiceCommand(runningServer, bundleId);
        try {
            String[] osgiService = serviceCommand.execute();
            if (osgiService != null) {
                NewLiferayModuleProjectOpMethods.setDenpendencies(file, osgiService[0], osgiService[1]);
            }
        }
        catch (Exception e) {
            ProjectCore.logError("Can't update project denpendencies. ", e);
        }
    }

    private static void setDenpendencies(File file, String bundleId, String bundleVersion) throws Exception {
        String content = new String(FileUtil.readContents((File)file, (boolean)true));
        String head = content.substring(0, content.lastIndexOf("dependencies"));
        String end = content.substring(content.lastIndexOf("}") + 1, content.length());
        String dependencies = content.substring(content.lastIndexOf("{") + 2, content.lastIndexOf("}"));
        String appended = "\tcompile 'com.liferay:" + bundleId + ":" + bundleVersion + "'\n";
        StringBuilder preNewContent = new StringBuilder();
        preNewContent.append(head);
        preNewContent.append("dependencies {\n");
        preNewContent.append(String.valueOf(dependencies) + appended);
        preNewContent.append("}");
        preNewContent.append(end);
        String newContent = preNewContent.toString();
        if (!content.equals(newContent)) {
            FileUtil.writeFileFromStream((File)file, (InputStream)new ByteArrayInputStream(newContent.getBytes()));
        }
    }
}

