/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementImpl;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.SetFactory;

public final class Index<T extends Element> {
    @Text(value="{0} property is already disposed.")
    private static LocalizableText propertyAlreadyDisposed;
    private static final Object NULL;
    private final ElementList<T> list;
    private final ValueProperty property;
    private final Comparator<String> comparator;
    private Map<Object, Object> keyToElements;
    private Map<Element, Object> elementToKey;
    private Listener listener;
    private ListenerContext listeners;

    static {
        LocalizableText.init(Index.class);
        NULL = new Object();
    }

    Index(ElementList<T> list, ValueProperty property, Comparator<String> comparator) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (comparator == null) {
            throw new IllegalArgumentException();
        }
        this.list = list;
        this.property = property;
        this.comparator = comparator;
    }

    private void initialize() {
        if (this.keyToElements == null) {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                @Override
                protected void handleTypedEvent(PropertyContentEvent event) {
                    Index.this.handle(event);
                }
            };
            this.list.attach(this.listener);
            Comparator<Object> comparator = null;
            if (this.comparator != null) {
                comparator = new Comparator<Object>(){

                    @Override
                    public int compare(Object x, Object y) {
                        if (x == y) {
                            return 0;
                        }
                        if (x == NULL) {
                            return -1;
                        }
                        if (y == NULL) {
                            return 1;
                        }
                        return Index.this.comparator.compare((String)x, (String)y);
                    }
                };
            }
            this.keyToElements = new TreeMap<Object, Object>(comparator);
            this.elementToKey = new IdentityHashMap<Element, Object>();
            for (Element element : this.list) {
                this.insert(element);
                element.attach(this.listener);
                element.property(this.property).attach(this.listener);
            }
        }
    }

    public ElementList<?> list() {
        return this.list;
    }

    public ValueProperty property() {
        return this.property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T element(String key) {
        Element element = this.list.root();
        synchronized (element) {
            this.assertNotDisposed();
            this.initialize();
            Object obj = this.keyToElements.get(key == null ? NULL : key);
            if (obj != null) {
                if (obj instanceof Element) {
                    return (T)((Element)obj);
                }
                return (T)((Element)((Set)obj).iterator().next());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> elements(String key) {
        Element element = this.list.root();
        synchronized (element) {
            this.assertNotDisposed();
            this.initialize();
            Object obj = this.keyToElements.get(key == null ? NULL : key);
            if (obj != null) {
                if (obj instanceof Element) {
                    return SetFactory.singleton((Element)obj);
                }
                return Collections.unmodifiableSet(new IdentityHashSet((Set)obj));
            }
        }
        return SetFactory.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.list.root();
        synchronized (element) {
            this.assertNotDisposed();
            if (this.listeners == null) {
                this.listeners = new ListenerContext(((ElementImpl)this.list.element()).queue());
            }
            this.listeners.attach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.list.root();
        synchronized (element) {
            if (this.listeners != null) {
                this.listeners.detach(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(PropertyContentEvent event) {
        Element element = this.list.root();
        synchronized (element) {
            boolean changed = false;
            Property property = event.property();
            if (property instanceof Value) {
                Element element2 = property.element();
                this.remove(element2);
                this.insert(element2);
                changed = true;
            } else {
                for (Element element3 : this.list) {
                    if (this.elementToKey.containsKey(element3)) continue;
                    this.insert(element3);
                    element3.attach(this.listener);
                    element3.property(this.property).attach(this.listener);
                    changed = true;
                }
                ArrayList<Element> disposed = null;
                for (Element element4 : this.elementToKey.keySet()) {
                    if (!element4.disposed()) continue;
                    if (disposed == null) {
                        disposed = new ArrayList<Element>(1);
                    }
                    disposed.add(element4);
                }
                if (disposed != null) {
                    for (Element element4 : disposed) {
                        this.remove(element4);
                    }
                    changed = true;
                }
            }
            if (changed && this.listeners != null) {
                this.listeners.broadcast(new Event());
            }
        }
    }

    private void insert(Element element) {
        Object object;
        if (element == null) {
            throw new IllegalStateException();
        }
        Object key = element.property(this.property).text();
        if (key == null) {
            key = NULL;
        }
        if ((object = this.keyToElements.get(key)) == null) {
            this.keyToElements.put(key, element);
        } else if (object instanceof Element) {
            IdentityHashSet set = new IdentityHashSet();
            set.add((Element)object);
            set.add(element);
            this.keyToElements.put(key, set);
        } else {
            Set set = (Set)object;
            set.add(element);
        }
        this.elementToKey.put(element, key);
    }

    private void remove(Element element) {
        Object object;
        if (element == null) {
            throw new IllegalStateException();
        }
        Object key = this.elementToKey.remove(element);
        if (key != null && (object = this.keyToElements.get(key)) != null) {
            if (object instanceof Element) {
                this.keyToElements.remove(key);
            } else {
                Set set = (Set)object;
                set.remove(element);
                if (set.size() == 1) {
                    this.keyToElements.put(key, set.iterator().next());
                }
            }
        }
    }

    private void assertNotDisposed() {
        if (this.list.disposed()) {
            String msg = propertyAlreadyDisposed.format(this.list.name());
            throw new IllegalStateException(msg);
        }
    }
}

