/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementImpl;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Observable;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Transient;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ElementCompiler {
    private final ElementType type;
    private final Class<?> typeInterfaceClass;
    private final String typeInterfaceClassInternalName;
    private final String typeImplClassInternalName;
    private final Set<Method> implementedMethods;

    public ElementCompiler(ElementType type) {
        this.type = type;
        this.typeInterfaceClass = this.type.getModelElementClass();
        this.typeInterfaceClassInternalName = Type.getInternalName(this.typeInterfaceClass);
        this.typeImplClassInternalName = String.valueOf(this.typeInterfaceClassInternalName) + "$Impl";
        this.implementedMethods = new HashSet<Method>();
    }

    public byte[] compile() {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 49, this.typeImplClassInternalName, null, Type.getInternalName(ElementImpl.class), new String[]{this.typeInterfaceClassInternalName});
        this.processConstructor(cw);
        for (PropertyDef property : this.type.properties()) {
            if (property instanceof ValueProperty) {
                this.processValueProperty(cw, (ValueProperty)property);
                continue;
            }
            if (property instanceof TransientProperty) {
                this.processTransientProperty(cw, (TransientProperty)property);
                continue;
            }
            if (property instanceof ListProperty) {
                this.processListProperty(cw, (ListProperty)property);
                continue;
            }
            if (property instanceof ImpliedElementProperty) {
                this.processImpliedElementProperty(cw, (ImpliedElementProperty)property);
                continue;
            }
            if (property instanceof ElementProperty) {
                this.processElementProperty(cw, (ElementProperty)property);
                continue;
            }
            throw new IllegalStateException(property.getClass().getName());
        }
        this.processDelegatedMethods(cw);
        this.processUnimplementedMethods(cw);
        return cw.toByteArray();
    }

    private void processConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Property.class), Type.getType(Resource.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, "TYPE", Type.getDescriptor(ElementType.class));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, Type.getInternalName(ElementImpl.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(ElementType.class), Type.getType(Property.class), Type.getType(Resource.class)}));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void processValueProperty(ClassWriter cw, ValueProperty property) {
        MethodVisitor mv;
        String propertyFieldName = this.findPropertyField(property).getName();
        Method getter = this.findMethod("get" + property.name(), new Class[0]);
        if (getter == null) {
            getter = this.findMethod("is" + property.name(), new Class[0]);
        }
        if (getter != null) {
            this.implementedMethods.add(getter);
            boolean reference = property.hasAnnotation(Reference.class);
            mv = cw.visitMethod(1, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(reference ? ReferenceValue.class : Value.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(ValueProperty.class));
            mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(Value.class), (Type[])new Type[]{Type.getType(ValueProperty.class)}));
            if (reference) {
                mv.visitTypeInsn(192, Type.getInternalName(ReferenceValue.class));
            }
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        if (!property.hasAnnotation(Derived.class) && !property.hasAnnotation(ReadOnly.class)) {
            Method typedSetter;
            Class<?> propertyTypeClass;
            Method setter = this.findMethod("set" + property.name(), String.class);
            if (setter != null) {
                this.implementedMethods.add(setter);
                mv = cw.visitMethod(1, setter.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(ValueProperty.class));
                mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(Value.class), (Type[])new Type[]{Type.getType(ValueProperty.class)}));
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, Type.getInternalName(Value.class), "write", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}));
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            if ((propertyTypeClass = property.getTypeClass()) != String.class && (typedSetter = this.findMethod("set" + property.name(), propertyTypeClass)) != null) {
                this.implementedMethods.add(typedSetter);
                MethodVisitor mv2 = cw.visitMethod(1, typedSetter.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(propertyTypeClass)}), null, null);
                mv2.visitCode();
                mv2.visitVarInsn(25, 0);
                mv2.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(ValueProperty.class));
                mv2.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(Value.class), (Type[])new Type[]{Type.getType(ValueProperty.class)}));
                mv2.visitVarInsn(25, 1);
                mv2.visitMethodInsn(182, Type.getInternalName(Value.class), "write", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}));
                mv2.visitInsn(177);
                mv2.visitMaxs(0, 0);
                mv2.visitEnd();
            }
        }
    }

    private void processTransientProperty(ClassWriter cw, TransientProperty property) {
        Method setter;
        String propertyFieldName = this.findPropertyField(property).getName();
        Class<?> propertyTypeClass = property.getTypeClass();
        Method getter = this.findMethod("get" + property.name(), new Class[0]);
        if (getter != null) {
            this.implementedMethods.add(getter);
            MethodVisitor mv = cw.visitMethod(1, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(Transient.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(TransientProperty.class));
            mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(Transient.class), (Type[])new Type[]{Type.getType(TransientProperty.class)}));
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        if ((setter = this.findMethod("set" + property.name(), propertyTypeClass)) != null) {
            this.implementedMethods.add(setter);
            MethodVisitor mv = cw.visitMethod(1, setter.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(propertyTypeClass)}), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(TransientProperty.class));
            mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(Transient.class), (Type[])new Type[]{Type.getType(TransientProperty.class)}));
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, Type.getInternalName(Transient.class), "write", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}));
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void processListProperty(ClassWriter cw, ListProperty property) {
        String propertyFieldName = this.findPropertyField(property).getName();
        Method getter = this.findMethod("get" + property.name(), new Class[0]);
        if (getter != null) {
            this.implementedMethods.add(getter);
            MethodVisitor mv = cw.visitMethod(1, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(ElementList.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(ListProperty.class));
            mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(ElementList.class), (Type[])new Type[]{Type.getType(ListProperty.class)}));
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void processElementProperty(ClassWriter cw, ElementProperty property) {
        String propertyFieldName = this.findPropertyField(property).getName();
        Method getter = this.findMethod("get" + property.name(), new Class[0]);
        if (getter != null) {
            this.implementedMethods.add(getter);
            MethodVisitor mv = cw.visitMethod(1, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(ElementHandle.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(ElementProperty.class));
            mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(ElementHandle.class), (Type[])new Type[]{Type.getType(ElementProperty.class)}));
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void processImpliedElementProperty(ClassWriter cw, ImpliedElementProperty property) {
        String propertyFieldName = this.findPropertyField(property).getName();
        Class<?> propertyTypeClass = property.getTypeClass();
        Method getter = this.findMethod("get" + property.name(), new Class[0]);
        if (getter != null) {
            this.implementedMethods.add(getter);
            MethodVisitor mv = cw.visitMethod(1, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(propertyTypeClass), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.typeInterfaceClassInternalName, propertyFieldName, Type.getDescriptor(ImpliedElementProperty.class));
            mv.visitMethodInsn(182, this.typeImplClassInternalName, "property", Type.getMethodDescriptor((Type)Type.getType(ElementHandle.class), (Type[])new Type[]{Type.getType(ElementProperty.class)}));
            mv.visitMethodInsn(182, Type.getInternalName(ElementHandle.class), "content", Type.getMethodDescriptor((Type)Type.getType(Element.class), (Type[])new Type[0]));
            mv.visitTypeInsn(192, Type.getInternalName(propertyTypeClass));
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void processDelegatedMethods(ClassWriter cw) {
        Method[] methodArray = this.typeInterfaceClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            DelegateImplementation delegateImplementationAnnotation = method.getAnnotation(DelegateImplementation.class);
            if (!this.implementedMethods.contains(method) && delegateImplementationAnnotation != null) {
                this.implementedMethods.add(method);
                Class<?>[] exceptionClasses = method.getExceptionTypes();
                String[] exceptionTypeNames = new String[exceptionClasses.length];
                int i = 0;
                int n3 = exceptionClasses.length;
                while (i < n3) {
                    exceptionTypeNames[i] = Type.getInternalName(exceptionClasses[i]);
                    ++i;
                }
                MethodVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), null, exceptionTypeNames);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, this.typeImplClassInternalName, "assertNotDisposed", "()V");
                Type[] methodParameterTypes = Type.getArgumentTypes((Method)method);
                Type[] delegateParameterTypes = new Type[methodParameterTypes.length + 1];
                mv.visitVarInsn(25, 0);
                delegateParameterTypes[0] = Type.getType(method.getDeclaringClass());
                int i2 = 0;
                int j = 1;
                int n4 = methodParameterTypes.length;
                while (i2 < n4) {
                    Type methodParameterType = methodParameterTypes[i2];
                    mv.visitVarInsn(methodParameterType.getOpcode(21), j);
                    delegateParameterTypes[j] = methodParameterType;
                    ++i2;
                    ++j;
                }
                mv.visitMethodInsn(184, Type.getInternalName(delegateImplementationAnnotation.value()), method.getName(), Type.getMethodDescriptor((Type)Type.getReturnType((Method)method), (Type[])delegateParameterTypes));
                mv.visitInsn(Type.getReturnType((Method)method).getOpcode(172));
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            ++n2;
        }
    }

    private void processUnimplementedMethods(ClassWriter cw) {
        Method[] methodArray = this.typeInterfaceClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> cl = method.getDeclaringClass();
            if (!this.implementedMethods.contains(method) && cl != Element.class && cl != Observable.class && cl != Disposable.class && cl != Object.class) {
                MethodVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
                mv.visitCode();
                mv.visitTypeInsn(187, Type.getInternalName(UnsupportedOperationException.class));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, Type.getInternalName(UnsupportedOperationException.class), "<init>", "()V");
                mv.visitInsn(191);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            ++n2;
        }
    }

    private Method findMethod(String methodName, Class<?> ... paramTypes) {
        Method[] methodArray = this.typeInterfaceClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] methodParamTypes;
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase(methodName) && (methodParamTypes = method.getParameterTypes()).length == paramTypes.length) {
                boolean paramsMatch = true;
                int i = 0;
                int n3 = paramTypes.length;
                while (i < n3) {
                    if (methodParamTypes[i] != paramTypes[i]) {
                        paramsMatch = false;
                        break;
                    }
                    ++i;
                }
                if (paramsMatch) {
                    return method;
                }
            }
            ++n2;
        }
        return null;
    }

    private Field findPropertyField(PropertyDef property) {
        Field[] fieldArray = this.typeInterfaceClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                if (field.get(null) == property) {
                    return field;
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            ++n2;
        }
        return null;
    }
}

