/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.CompositeReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.internal.ui.text.java.JavaReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingReconcileStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private JavaReconcilingStrategy fJavaStrategy;

    public JavaCompositeReconcilingStrategy(ISourceViewer viewer, ITextEditor editor, String documentPartitioning) {
        this.fEditor = editor;
        this.fJavaStrategy = new JavaReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fJavaStrategy, new JavaSpellingReconcileStrategy(viewer, editor)});
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel m;
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)this.fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        block7: {
            try {
                IProblemRequestorExtension e = this.getProblemRequestorExtension();
                if (e != null) {
                    try {
                        e.beginReportingSequence();
                        super.reconcile(dirtyRegion, subRegion);
                        break block7;
                    }
                    finally {
                        e.endReportingSequence();
                    }
                }
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                this.reconciled();
            }
        }
    }

    public void reconcile(IRegion partition) {
        block7: {
            try {
                IProblemRequestorExtension e = this.getProblemRequestorExtension();
                if (e != null) {
                    try {
                        e.beginReportingSequence();
                        super.reconcile(partition);
                        break block7;
                    }
                    finally {
                        e.endReportingSequence();
                    }
                }
                super.reconcile(partition);
            }
            finally {
                this.reconciled();
            }
        }
    }

    public void notifyListeners(boolean notify) {
        this.fJavaStrategy.notifyListeners(notify);
    }

    public void initialReconcile() {
        block7: {
            try {
                IProblemRequestorExtension e = this.getProblemRequestorExtension();
                if (e != null) {
                    try {
                        e.beginReportingSequence();
                        super.initialReconcile();
                        break block7;
                    }
                    finally {
                        e.endReportingSequence();
                    }
                }
                super.initialReconcile();
            }
            finally {
                this.reconciled();
            }
        }
    }

    public void aboutToBeReconciled() {
        this.fJavaStrategy.aboutToBeReconciled();
    }

    private void reconciled() {
        this.fJavaStrategy.reconciled();
    }
}

