/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.operation;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.StringBufferOutputStream;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.HookCore;
import com.liferay.ide.hook.core.dd.HookDescriptorHelper;
import com.liferay.ide.hook.core.operation.INewHookDataModelProperties;
import com.liferay.ide.hook.core.util.HookUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddHookOperation
extends AbstractDataModelOperation
implements INewHookDataModelProperties {
    public AddHookOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IDataModel dm = this.getDataModel();
        IStatus retval = null;
        IStatus status = this.checkDescriptorFile(this.getTargetProject());
        if (!status.isOK()) {
            return status;
        }
        if (dm.getBooleanProperty("INewHookDataModelProperties.CREATE_CUSTOM_JSPS")) {
            retval = this.createCustomJSPs(dm);
        }
        if (dm.getBooleanProperty("INewHookDataModelProperties.CREATE_PORTAL_PROPERTIES")) {
            retval = this.createPortalProperties(dm);
        }
        if (dm.getBooleanProperty("INewHookDataModelProperties.CREATE_SERVICES")) {
            retval = this.createServices(dm);
        }
        if (dm.getBooleanProperty("INewHookDataModelProperties.CREATE_LANGUAGE_PROPERTIES")) {
            retval = this.createLanguageProperties(dm);
        }
        return retval;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtil.getProject((String)projectName);
    }

    protected IStatus checkDescriptorFile(IProject project) {
        Path path;
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project);
        if (webproject == null || webproject.getDefaultDocrootFolder() == null) {
            return HookCore.createErrorStatus("Could not find webapp root folder.");
        }
        IFolder webappRoot = webproject.getDefaultDocrootFolder();
        IFile hookDescriptorFile = webappRoot.getFile((IPath)(path = new Path("WEB-INF/liferay-hook.xml")));
        if (!hookDescriptorFile.exists()) {
            try {
                this.createDefaultHookDescriptorFile(hookDescriptorFile);
            }
            catch (Exception ex) {
                return HookCore.createErrorStatus(ex);
            }
        }
        return Status.OK_STATUS;
    }

    protected IFile copyPortalJSPToProject(IPath portalDir, String portalJsp, IFolder customFolder) throws Exception {
        Path portalJspPath = new Path(portalJsp);
        IPath originalPortalJspPath = portalDir.append(portalJsp);
        IFile newJspFile = customFolder.getFile((IPath)portalJspPath);
        CoreUtil.prepareFolder((IFolder)((IFolder)newJspFile.getParent()));
        if (originalPortalJspPath.toFile().exists()) {
            FileInputStream fis = new FileInputStream(originalPortalJspPath.toFile());
            if (newJspFile.exists()) {
                newJspFile.setContents((InputStream)fis, 1, null);
            } else {
                newJspFile.create((InputStream)fis, true, null);
            }
        } else {
            CoreUtil.createEmptyFile((IFile)newJspFile);
        }
        return newJspFile;
    }

    protected IStatus createCustomJSPs(IDataModel dm) {
        IProject project = this.getTargetProject();
        IFolder defaultWebappRootFolder = ((IWebProject)LiferayCore.create(IWebProject.class, (Object)project)).getDefaultDocrootFolder();
        String customJSPsFolder = dm.getStringProperty("INewHookDataModelProperties.CUSTOM_JSPS_FOLDER");
        String customFolderValue = defaultWebappRootFolder.getFullPath().append(customJSPsFolder).toPortableString();
        IFolder customFolder = project.getWorkspace().getRoot().getFolder((IPath)new Path(customFolderValue));
        try {
            CoreUtil.prepareFolder((IFolder)customFolder);
        }
        catch (CoreException e) {
            return HookCore.createErrorStatus((Exception)((Object)e));
        }
        List customJsps = (List)dm.getProperty("INewHookDataModelProperties.CUSTOM_JSPS_ITEMS");
        ILiferayProject liferayProject = LiferayCore.create((Object)this.getTargetProject());
        ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
        IStatus status = null;
        if (portal != null) {
            IPath portalDir = portal.getAppServerPortalDir();
            if (customJsps != null && portalDir != null) {
                for (String[] customJsp : customJsps) {
                    try {
                        IFile copiedFile = this.copyPortalJSPToProject(portalDir, customJsp[0], customFolder);
                        if (copiedFile == null) continue;
                        Set jspFilesCreated = (Set)dm.getProperty("INewHookDataModelProperties.CUSTOM_JSPS_FILES_CREATED");
                        jspFilesCreated.add(copiedFile);
                        dm.setProperty("INewHookDataModelProperties.CUSTOM_JSPS_FILES_CREATED", (Object)jspFilesCreated);
                    }
                    catch (Exception e) {
                        HookCore.logError(e);
                    }
                }
            }
            HookDescriptorHelper hookDescHelper = new HookDescriptorHelper(this.getTargetProject());
            status = hookDescHelper.setCustomJSPDir(this.model);
            if (this.model.getBooleanProperty("INewHookDataModelProperties.DISABLE_CUSTOM_JSP_FOLDER_VALIDATION")) {
                HookUtil.configureJSPSyntaxValidationExclude(this.getTargetProject(), customFolder, true);
            }
        } else {
            status = HookCore.createErrorStatus("Could not get portal info from project " + project.getName());
        }
        return status;
    }

    protected void createDefaultHookDescriptorFile(IFile hookDescriptorFile) throws UnsupportedEncodingException, CoreException, BadLocationException, TemplateException {
        HookDescriptorHelper helper = new HookDescriptorHelper(this.getTargetProject());
        helper.createDefaultDescriptor();
    }

    protected IStatus createLanguageProperties(IDataModel dm) {
        IProject project = this.getTargetProject();
        String contentFolderValue = dm.getStringProperty("INewHookDataModelProperties.CONTENT_FOLDER");
        IFolder contentFolder = project.getWorkspace().getRoot().getFolder((IPath)new Path(contentFolderValue));
        try {
            CoreUtil.prepareFolder((IFolder)contentFolder);
        }
        catch (CoreException e) {
            return HookCore.createErrorStatus((Exception)((Object)e));
        }
        List languagePropertiesFiles = (List)dm.getProperty("INewHookDataModelProperties.LANGUAGE_PROPERTIES_ITEMS");
        if (languagePropertiesFiles != null) {
            for (String[] languagePropertyFile : languagePropertiesFiles) {
                try {
                    IFile createdFile;
                    if (languagePropertyFile[0].contains("*") || (createdFile = ProjectUtil.createEmptyProjectFile((String)languagePropertyFile[0], (IFolder)contentFolder)) == null) continue;
                    Set languageFilesCreated = (Set)dm.getProperty("INewHookDataModelProperties.LANGUAGE_PROPERTIES_FILES_CREATED");
                    languageFilesCreated.add(createdFile);
                    dm.setProperty("INewHookDataModelProperties.LANGUAGE_PROPERTIES_FILES_CREATED", (Object)languageFilesCreated);
                }
                catch (Exception e) {
                    HookCore.logError(e);
                }
            }
        }
        HookDescriptorHelper hookDescHelper = new HookDescriptorHelper(this.getTargetProject());
        Set languageFilesCreated = (Set)dm.getProperty("INewHookDataModelProperties.LANGUAGE_PROPERTIES_FILES_CREATED");
        ArrayList<String> languageProperties = new ArrayList<String>();
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        if (packRoot != null) {
            for (IFile languageFile : languageFilesCreated) {
                if (!packRoot.getPath().isPrefixOf(languageFile.getFullPath())) continue;
                String languageProperty = languageFile.getFullPath().makeRelativeTo(packRoot.getPath()).toPortableString();
                languageProperties.add(languageProperty);
            }
        }
        IStatus status = hookDescHelper.addLanguageProperties(languageProperties);
        return status;
    }

    protected IStatus createPortalProperties(IDataModel dm) {
        List overrideItems;
        List actionItems;
        IProject project = this.getTargetProject();
        String portalPropertiesFile = dm.getStringProperty("INewHookDataModelProperties.PORTAL_PROPERTIES_FILE");
        Path portalPropertiesPath = new Path(portalPropertiesFile);
        IPath propertiesFilesPath = portalPropertiesPath.makeRelativeTo(project.getFullPath());
        IFile propertiesFile = project.getFile(propertiesFilesPath);
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            try {
                properties.load(propertiesFile.getContents());
            }
            catch (Exception e) {
                return HookCore.createErrorStatus(e);
            }
        }
        if ((actionItems = (List)dm.getProperty("INewHookDataModelProperties.PORTAL_PROPERTIES_ACTIONS_ITEMS")) != null) {
            for (String[] actionItem : actionItems) {
                properties.put(actionItem[0], actionItem[1]);
            }
        }
        if ((overrideItems = (List)dm.getProperty("INewHookDataModelProperties.PORTAL_PROPERTIES_OVERRIDE_ITEMS")) != null) {
            for (String[] overrideItem : overrideItems) {
                properties.put(overrideItem[0], overrideItem[1]);
            }
        }
        StringBufferOutputStream buffer = new StringBufferOutputStream();
        try {
            properties.store((OutputStream)buffer, "");
        }
        catch (IOException e) {
            return HookCore.createErrorStatus(e);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
            if (propertiesFile.exists()) {
                propertiesFile.setContents((InputStream)bis, 1, null);
            } else {
                CoreUtil.prepareFolder((IFolder)((IFolder)propertiesFile.getParent()));
                propertiesFile.create((InputStream)bis, true, null);
            }
        }
        catch (Exception e) {
            return HookCore.createErrorStatus(e);
        }
        HookDescriptorHelper hookDescHelper = new HookDescriptorHelper(this.getTargetProject());
        String propertiesClasspath = null;
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        if (packRoot != null && packRoot.getPath().isPrefixOf(propertiesFile.getFullPath())) {
            propertiesClasspath = propertiesFile.getFullPath().makeRelativeTo(packRoot.getPath()).toPortableString();
        }
        IStatus status = hookDescHelper.setPortalProperties(this.model, propertiesClasspath);
        return status;
    }

    protected IStatus createServices(IDataModel dm) {
        List actionItems = (List)dm.getProperty("INewHookDataModelProperties.SERVICES_ITEMS");
        HookDescriptorHelper hookDescHelper = new HookDescriptorHelper(this.getTargetProject());
        IStatus status = hookDescHelper.addActionItems(actionItems);
        return status;
    }
}

