/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import aQute.remote.api.Agent;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundlePublishOperation;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.dto.BundleDTO;

public class BundlePublishFullRemove
extends BundlePublishOperation {
    public BundlePublishFullRemove(IServer server, IModule[] modules, BundleSupervisor supervisor, BundleDTO[] existingBundles) {
        super(server, modules, supervisor, existingBundles);
    }

    @Override
    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        for (IModule module : this.modules) {
            if (module.getProject() == null) continue;
            IStatus status = null;
            IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)module.getProject());
            if (bundleProject != null) {
                String symbolicName = bundleProject.getSymbolicName();
                if (this.server.getServerState() == 2) {
                    monitor.subTask("Remotely undeploying " + module.getName() + " from Liferay module framework...");
                    status = this.remoteUninstall(bundleProject, symbolicName);
                }
                if (status == null || status.isOK()) {
                    status = this.localUninstall(bundleProject, symbolicName);
                }
                if (status.isOK()) {
                    this.portalServerBehavior.setModulePublishState2(new IModule[]{module}, 1);
                }
            } else {
                status = LiferayServerCore.error("Could not get module publisher for project " + module.getProject().getName());
            }
            if (status.isOK()) continue;
            throw new CoreException(status);
        }
    }

    private void findFilesInPath(File dir, String pattern, List<File> retval) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().contains(pattern) && !retval.contains(f)) {
                    retval.add(f);
                } else if (f.isDirectory()) {
                    this.findFilesInPath(f, pattern, retval);
                }
                ++n2;
            }
        }
    }

    private IStatus localUninstall(IBundleProject bundleProject, String symbolicName) {
        IStatus retval = null;
        PortalRuntime runtime = (PortalRuntime)this.server.getRuntime().loadAdapter(PortalRuntime.class, null);
        ArrayList<File> moduleFiles = new ArrayList<File>();
        IPath modulesPath = runtime.getPortalBundle().getModulesPath();
        this.findFilesInPath(modulesPath.toFile(), symbolicName, moduleFiles);
        IPath deployPath = runtime.getPortalBundle().getAutoDeployPath();
        this.findFilesInPath(deployPath.toFile(), symbolicName, moduleFiles);
        IPath appServerDeployPath = runtime.getPortalBundle().getAppServerDeployDir();
        this.findFilesInPath(appServerDeployPath.toFile(), symbolicName, moduleFiles);
        try {
            IPath outputFile = bundleProject.getOutputBundle(false, null);
            this.findFilesInPath(modulesPath.toFile(), outputFile.lastSegment(), moduleFiles);
            this.findFilesInPath(deployPath.toFile(), outputFile.lastSegment(), moduleFiles);
            this.findFilesInPath(appServerDeployPath.toFile(), symbolicName, moduleFiles);
        }
        catch (CoreException coreException) {}
        IPath appServerDeployDir = runtime.getPortalBundle().getAppServerDeployDir();
        this.findFilesInPath(appServerDeployDir.toFile(), symbolicName, moduleFiles);
        if (moduleFiles.size() > 0) {
            for (File moduleFile : moduleFiles) {
                if (moduleFile.isDirectory()) {
                    FileUtil.deleteDir((File)moduleFile, (boolean)true);
                    continue;
                }
                retval = moduleFile.exists() && moduleFile.delete() ? Status.OK_STATUS : LiferayServerCore.error("Could not delete module file " + moduleFile.getName());
            }
        }
        if (retval == null) {
            LiferayServerCore.logInfo("No module to remove " + symbolicName);
            retval = Status.OK_STATUS;
        }
        return retval;
    }

    private IStatus remoteUninstall(IBundleProject bundleProject, String symbolicName) {
        IStatus retval = null;
        if (symbolicName != null && this._existingBundles != null && this._supervisor != null) {
            try {
                BundleDTO[] bundleDTOArray = this._existingBundles;
                int n = this._existingBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDTO bundle = bundleDTOArray[n2];
                    if (symbolicName.equals(bundle.symbolicName)) {
                        String error = ((Agent)this._supervisor.getAgent()).uninstall(new long[]{bundle.id});
                        retval = error == null ? Status.OK_STATUS : LiferayServerCore.error("Unable to uninstall bundle " + error);
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                retval = LiferayServerCore.error("Unable to uninstall bundle " + symbolicName, e);
            }
        }
        if (retval == null) {
            retval = Status.OK_STATUS;
        }
        return retval;
    }
}

