/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebServicesHelper {
    protected URL webServicesListURL;
    protected Map<String, String> wsdlNameURLMap = null;

    public WebServicesHelper(URL webServicesListURL) {
        this.webServicesListURL = webServicesListURL;
    }

    public String[] getWebServiceNames() {
        if (this.wsdlNameURLMap == null) {
            this.initMap();
        }
        return this.wsdlNameURLMap.keySet().toArray(new String[0]);
    }

    protected void initMap() {
        try {
            this.wsdlNameURLMap = new HashMap<String, String>();
            String webServicesString = CoreUtil.readStreamToString((InputStream)this.webServicesListURL.openStream());
            List<String> wsdlUrls = this.pullLinks(webServicesString);
            for (String url : wsdlUrls) {
                String name = this.pullServiceName(url);
                if (CoreUtil.isNullOrEmpty((String)name)) continue;
                this.wsdlNameURLMap.put(name, url);
            }
        }
        catch (IOException iOException) {
            LiferayServerCore.logError("Unable to initial web services list.");
        }
    }

    private List<String> pullLinks(String text) {
        ArrayList<String> links = new ArrayList<String>();
        String regex = "\\(?\\b(http://|www[.])[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String urlStr = m.group();
            if (urlStr.startsWith("(") && urlStr.endsWith(")")) {
                urlStr = urlStr.substring(1, urlStr.length() - 1);
            }
            links.add(urlStr);
        }
        return links;
    }

    private String pullServiceName(String wsdlUrl) {
        String regex = "axis/(\\w+)\\?wsdl$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(wsdlUrl);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getWebServiceWSDLURLByName(String serviceName) {
        if (this.wsdlNameURLMap == null) {
            this.initMap();
        }
        return this.wsdlNameURLMap.get(serviceName);
    }
}

