/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.WizardUtil;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.operation.INewServiceBuilderDataModelProperties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Version;

public class AddServiceBuilderOperation
extends AbstractDataModelOperation
implements INewServiceBuilderDataModelProperties {
    public AddServiceBuilderOperation(IDataModel model) {
        super(model);
    }

    public void createDefaultServiceBuilderFile(IFile serviceBuilderFile, IProgressMonitor monitor) throws CoreException {
        String descriptorVersion = null;
        try {
            ILiferayProject liferayProject = LiferayCore.create((Object)serviceBuilderFile.getProject());
            ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
            Version portalVersion = new Version(portal.getVersion());
            descriptorVersion = String.valueOf(portalVersion.getMajor()) + "." + portalVersion.getMinor() + ".0";
        }
        catch (Exception e) {
            ProjectCore.logError((String)"Could not determine liferay runtime version", (Exception)e);
            descriptorVersion = "6.0.0";
        }
        WizardUtil.createDefaultServiceBuilderFile((IFile)serviceBuilderFile, (String)descriptorVersion, (boolean)this.getDataModel().getBooleanProperty("INewServiceBuilderDataModelProperties.USE_SAMPLE_TEMPLATE"), (String)this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.PACKAGE_PATH"), (String)this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.NAMESPACE"), (Object)this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.AUTHOR"), (IProgressMonitor)monitor);
        this.getDataModel().setProperty("INewServiceBuilderDataModelProperties.CREATED_SERVICE_FILE", (Object)serviceBuilderFile);
    }

    private IStatus createServiceBuilderFile(IProject project, IProgressMonitor monitor) {
        Path path;
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project);
        if (webproject == null || webproject.getDefaultDocrootFolder() == null) {
            return ServiceCore.createErrorStatus("Could not find webapp root folder.");
        }
        IFolder defaultDocroot = webproject.getDefaultDocrootFolder();
        IFile serviceBuilderFile = defaultDocroot.getFile((IPath)(path = new Path("WEB-INF/" + this.getDataModel().getStringProperty("INewServiceBuilderDataModelProperties.SERVICE_FILE"))));
        if (!serviceBuilderFile.exists()) {
            try {
                this.createDefaultServiceBuilderFile(serviceBuilderFile, monitor);
            }
            catch (Exception ex) {
                return ServiceCore.createErrorStatus(ex);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus retval = null;
        IStatus status = this.createServiceBuilderFile(this.getTargetProject(), monitor);
        if (!status.isOK()) {
            return status;
        }
        return retval;
    }

    protected IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtil.getProject((String)projectName);
    }
}

