/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.util.ComponentUtil;
import com.liferay.ide.xml.search.ui.CommonWorkbenchMarkerResolution;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class AbstractResourceBundleMarkerResolution
extends CommonWorkbenchMarkerResolution {
    public AbstractResourceBundleMarkerResolution(IMarker marker) {
        super(marker);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> otherMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker != null && !marker.equals((Object)this.marker) && "portlet.language.properties.querySpecification".equals(marker.getAttribute("querySpecificationId", ""))) {
                otherMarkers.add(marker);
            }
            ++n2;
        }
        return otherMarkers.toArray(new IMarker[0]);
    }

    public String getDescription() {
        return this.getLabel();
    }

    protected String getResourceKey(IMarker marker) {
        if (marker == null) {
            return "";
        }
        return marker.getAttribute("textContent", "");
    }

    protected String getDefaultResourceValue(String resourceKey) {
        if (CoreUtil.isNullOrEmpty((String)resourceKey)) {
            return "";
        }
        String[] words = resourceKey.split("-");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (i == 0) {
                word = word.replaceFirst(word.substring(0, 1), word.substring(0, 1).toUpperCase());
            }
            sb.append(word);
            sb.append(" ");
            ++i;
        }
        return sb.toString().trim();
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        HashSet<IFile> files = new HashSet<IFile>();
        int i = 0;
        while (i < markers.length) {
            monitor.subTask(Util.getProperty((String)"message", (IMarker)markers[i]));
            this.resolve(markers[i]);
            IResource resource = markers[i].getResource();
            if (resource instanceof IFile && !files.contains(resource)) {
                files.add((IFile)resource);
            }
            ++i;
        }
        for (IFile file : files) {
            ComponentUtil.validateFile((IFile)file, (IProgressMonitor)monitor);
        }
    }
}

