/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.xml.search.ui.CommonWorkbenchMarkerResolution;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import com.liferay.ide.xml.search.ui.MarkerResolutionProposal;
import com.liferay.ide.xml.search.ui.TempMarker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class JSPQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        TemporaryAnnotation temp;
        return annotation instanceof TemporaryAnnotation && (temp = (TemporaryAnnotation)annotation).getAttributes() != null && temp.getAttributes().get("querySpecificationId") != null;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext context) {
        ICompletionProposal[] retval = null;
        ArrayList proposals = new ArrayList();
        ISourceViewer sourceViewer = context.getSourceViewer();
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        Iterator annotations = annotationModel.getAnnotationIterator();
        while (annotations.hasNext()) {
            Annotation annotation = (Annotation)annotations.next();
            Position position = annotationModel.getPosition(annotation);
            try {
                Object[] resolutions;
                IMarker marker = this.createTempMarker(annotation);
                int lineNum = sourceViewer.getDocument().getLineOfOffset(position.getOffset()) + 1;
                int currentLineNum = sourceViewer.getDocument().getLineOfOffset(context.getOffset()) + 1;
                if (marker == null || currentLineNum != lineNum || marker.getAttribute("querySpecificationId", null) == null || CoreUtil.isNullOrEmpty((Object[])(resolutions = this.createFromMarkerResolutions(marker)))) continue;
                Collections.addAll(proposals, resolutions);
                if (!(annotation instanceof IQuickFixableAnnotation)) continue;
                IQuickFixableAnnotation quick = (IQuickFixableAnnotation)annotation;
                quick.setQuickFixable(true);
            }
            catch (BadLocationException e) {
                LiferayXMLSearchUI.logError("Error finding quick assists", (Exception)((Object)e));
            }
        }
        if (proposals.size() > 0) {
            retval = proposals.toArray(new ICompletionProposal[0]);
        }
        return retval;
    }

    private ICompletionProposal[] createFromMarkerResolutions(IMarker marker) {
        ArrayList<MarkerResolutionProposal> retval = new ArrayList<MarkerResolutionProposal>();
        if (IDE.getMarkerHelpRegistry().hasResolutions(marker)) {
            IMarkerResolution[] resolutions;
            IMarkerResolution[] iMarkerResolutionArray = resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution resolution = iMarkerResolutionArray[n2];
                if (resolution instanceof CommonWorkbenchMarkerResolution) {
                    retval.add(new MarkerResolutionProposal(resolution, marker));
                }
                ++n2;
            }
        }
        return retval.toArray(new ICompletionProposal[0]);
    }

    private IMarker createTempMarker(Annotation annotation) {
        TemporaryAnnotation temp;
        if (annotation instanceof TemporaryAnnotation && (temp = (TemporaryAnnotation)annotation).getAttributes() != null) {
            return new TempMarker((TemporaryAnnotation)annotation);
        }
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

