/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.validators.LiferayBaseValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.w3c.dom.Attr;

public class LiferayDisplayDescriptorValidator
extends LiferayBaseValidator {
    public static final String MESSAGE_CATEGORY_NAME_CANNOT_BE_EMPTY = Msgs.categoryNameCannotBeEmpty;

    @Override
    protected boolean validateSyntax(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        int severity = this.getServerity(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
        if (severity != -1 && node.getNodeType() == 2 && "name".equals(node.getNodeName()) && "category".equals(((Attr)node).getOwnerElement().getNodeName()) && node.getNodeValue().matches("\\s*")) {
            String liferayPluginValidationType = this.getLiferayPluginValidationType(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
            String validationMsg = MESSAGE_CATEGORY_NAME_CANNOT_BE_EMPTY;
            this.addMessage(node, file, validator, reporter, batchMode, validationMsg, severity, liferayPluginValidationType);
            return false;
        }
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String categoryNameCannotBeEmpty;

        static {
            Msgs.initializeMessages((String)LiferayDisplayDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

