/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.validators.LiferayBaseValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.w3c.dom.Node;

public class LiferayPortletDescriptorValidator
extends LiferayBaseValidator {
    public static final String MESSAGE_ENTRY_WEIGHT_SYNTAX_INVALID = Msgs.entryWeightSyntaxInvalid;

    @Override
    protected boolean validateSyntax(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        int severity = this.getServerity(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
        if (severity != -1 && node.getParentNode().getNodeName().equals("control-panel-entry-weight")) {
            String validationMsg = null;
            String nodeValue = DOMUtils.getNodeValue((Node)node);
            if (nodeValue != null) {
                try {
                    Double.parseDouble(nodeValue);
                }
                catch (NumberFormatException numberFormatException) {
                    validationMsg = NLS.bind((String)MESSAGE_ENTRY_WEIGHT_SYNTAX_INVALID, (Object)nodeValue);
                }
            }
            if (validationMsg != null) {
                String liferayPluginValidationType = this.getLiferayPluginValidationType(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
                this.addMessage(node, file, validator, reporter, batchMode, validationMsg, severity, liferayPluginValidationType);
                return false;
            }
        }
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String entryWeightSyntaxInvalid;

        static {
            Msgs.initializeMessages((String)LiferayPortletDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

