/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.VirtualNamedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedColumn;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmNamedColumn<PA extends NamedColumn.ParentAdapter, X extends XmlNamedColumn>
extends AbstractOrmXmlContextModel<JpaContextModel>
implements OrmSpecifiedNamedColumn {
    protected final PA parentAdapter;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;
    protected Table dbTable;

    protected AbstractOrmNamedColumn(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractOrmNamedColumn(PA parentAdapter, X xmlColumn) {
        super(parentAdapter.getColumnParent());
        this.parentAdapter = parentAdapter;
        this.setXmlColumn(xmlColumn);
        this.specifiedName = this.buildSpecifiedName();
        this.columnDefinition = this.buildColumnDefinition();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setColumnDefinition_(this.buildColumnDefinition());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDbTable(this.buildDbTable());
    }

    public abstract X getXmlColumn();

    protected void setXmlColumn(X xmlColumn) {
        if (xmlColumn != null) {
            throw new IllegalArgumentException("this method must be overridden if the XML column is not null: " + xmlColumn);
        }
    }

    protected X getXmlColumnForUpdate() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn != null ? xmlColumn : this.buildXmlColumn();
    }

    protected abstract X buildXmlColumn();

    protected void removeXmlColumnIfUnset() {
        if (this.getXmlColumn().isUnset()) {
            this.removeXmlColumn();
        }
    }

    protected abstract void removeXmlColumn();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (ObjectTools.notEquals((Object)this.specifiedName, (Object)name)) {
            X xmlColumn = this.getXmlColumnForUpdate();
            this.setSpecifiedName_(name);
            xmlColumn.setName(name);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.parentAdapter.getDefaultColumnName(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (ObjectTools.notEquals((Object)this.columnDefinition, (Object)columnDefinition)) {
            X xmlColumn = this.getXmlColumnForUpdate();
            this.setColumnDefinition_(columnDefinition);
            xmlColumn.setColumnDefinition(columnDefinition);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setColumnDefinition_(String columnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    protected String buildColumnDefinition() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getColumnDefinition();
    }

    protected Column getDbColumn() {
        return this.dbTable == null ? null : this.dbTable.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.dbTable;
    }

    protected void setDbTable(Table dbTable) {
        Table old = this.dbTable;
        this.dbTable = dbTable;
        this.firePropertyChanged("dbTable", old, dbTable);
    }

    protected Table buildDbTable() {
        return this.parentAdapter.resolveDbTable(this.getTableName());
    }

    @Override
    public String getTableName() {
        return this.parentAdapter.getDefaultTableName();
    }

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildColumnValidator().validate(messages, reporter);
    }

    protected JpaValidator buildColumnValidator() {
        return this.parentAdapter.buildColumnValidator(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlColumnTextRange();
        return textRange != null ? textRange : this.parentAdapter.getValidationTextRange();
    }

    protected TextRange getXmlColumnTextRange() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getValidationTextRange();
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getValidationTextRange(this.getXmlColumnNameTextRange());
    }

    protected TextRange getXmlColumnNameTextRange() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getNameTextRange();
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.columnNameTouches(pos)) {
            return this.getCandidateColumnNames();
        }
        return null;
    }

    protected boolean columnNameTouches(int pos) {
        X column = this.getXmlColumn();
        return column != null && column.columnNameTouches(pos);
    }

    protected Iterable<String> getCandidateColumnNames() {
        return this.dbTable != null ? this.dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    protected void initializeFrom(OrmSpecifiedNamedColumn oldColumn) {
        this.setSpecifiedName(oldColumn.getSpecifiedName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }

    protected void initializeFrom(VirtualNamedColumn virtualColumn) {
        this.setSpecifiedName(virtualColumn.getName());
        this.setColumnDefinition(virtualColumn.getColumnDefinition());
    }

    public void toString(StringBuilder sb) {
        String table = this.getTableName();
        if (table != null) {
            sb.append(table);
            sb.append('.');
        }
        sb.append(this.getName());
    }
}

