/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.jsdt.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import tern.eclipse.ide.jsdt.internal.ui.JSDTDocumentRegionProcessor;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.utils.EditorUtils;

public class JavaEditorTracker
implements IWindowListener,
IPageListener,
IPartListener {
    static JavaEditorTracker INSTANCE;
    Map<IEditorPart, JSDTDocumentRegionProcessor> fAsYouTypeValidators = new HashMap<IEditorPart, JSDTDocumentRegionProcessor>();

    private JavaEditorTracker() {
        this.init();
    }

    public static JavaEditorTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaEditorTracker();
        }
        return INSTANCE;
    }

    private void init() {
        IWorkbench workbench;
        if (PlatformUI.isWorkbenchRunning() && (workbench = TernUIPlugin.getDefault().getWorkbench()) != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                this.windowOpened(window);
                ++n2;
            }
            TernUIPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)this);
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.pageClosed(page);
            ++n2;
        }
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (window.getShell() != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                this.pageOpened(page);
                ++n2;
            }
            window.addPageListener((IPageListener)this);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        IEditorReference[] rs;
        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference r = iEditorReferenceArray[n2];
            IEditorPart part = r.getEditor(false);
            if (part != null) {
                this.editorClosed(part);
            }
            ++n2;
        }
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        IEditorReference[] rs;
        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference r = iEditorReferenceArray[n2];
            IEditorPart part = r.getEditor(false);
            if (part != null) {
                this.editorOpened(part);
            }
            ++n2;
        }
        page.addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorClosed((IEditorPart)part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorOpened((IEditorPart)part);
        }
    }

    private void editorOpened(IEditorPart part) {
        ISourceViewer viewer;
        IResource resource;
        if (part instanceof JavaEditor && (resource = EditorUtils.getResource((IEditorPart)part)) != null && (viewer = EditorUtils.getSourceViewer((IEditorPart)part)) != null) {
            JSDTDocumentRegionProcessor processor = this.fAsYouTypeValidators.get(part);
            if (processor != null) {
                this.editorClosed(part);
                Assert.isTrue((this.fAsYouTypeValidators.get(part) == null ? 1 : 0) != 0, (String)"An old JavaDirtyRegionProcessor is not un-installed on Java Editor instance");
            }
            processor = new JSDTDocumentRegionProcessor();
            processor.install((ITextViewer)viewer);
            processor.setDocument(viewer.getDocument());
            processor.startReconciling();
            this.fAsYouTypeValidators.put(part, processor);
        }
    }

    private void editorClosed(IEditorPart part) {
        JSDTDocumentRegionProcessor processor;
        if (part instanceof ITextEditor && (processor = this.fAsYouTypeValidators.remove(part)) != null) {
            processor.uninstall();
            Assert.isTrue((this.fAsYouTypeValidators.get(part) == null ? 1 : 0) != 0, (String)"An old JavaDirtyRegionProcessor is not un-installed on Java Editor instance");
        }
    }
}

