/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivyde.eclipse.NopMessageLogger;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.console.IvyConsole;

public class IvyDEMessage {
    public static void debug(String msg) {
        IvyDEMessage.getLogger().debug(msg);
    }

    private static MessageLogger getLogger() {
        IvyPlugin plugin = IvyPlugin.getDefault();
        if (plugin == null) {
            return NopMessageLogger.INSTANCE;
        }
        IvyConsole console = plugin.getConsole();
        if (console == null) {
            return NopMessageLogger.INSTANCE;
        }
        return console.getIvyDEMessageLogger();
    }

    public static void verbose(String msg) {
        IvyDEMessage.getLogger().verbose(msg);
    }

    public static void info(String msg) {
        IvyDEMessage.getLogger().info(msg);
    }

    public static void rawinfo(String msg) {
        IvyDEMessage.getLogger().rawinfo(msg);
    }

    public static void deprecated(String msg) {
        IvyDEMessage.getLogger().deprecated(msg);
    }

    public static void warn(String msg) {
        IvyDEMessage.getLogger().warn(msg);
    }

    public static void error(String msg) {
        IvyDEMessage.getLogger().error(msg);
    }

    public static void log(int logLevel, String msg) {
        switch (logLevel) {
            case 4: {
                IvyDEMessage.debug(msg);
                break;
            }
            case 3: {
                IvyDEMessage.verbose(msg);
                break;
            }
            case 2: {
                IvyDEMessage.info(msg);
                break;
            }
            case 1: {
                IvyDEMessage.warn(msg);
                break;
            }
            case 0: {
                IvyDEMessage.error(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level " + logLevel);
            }
        }
    }

    public static List getProblems() {
        return IvyDEMessage.getLogger().getProblems();
    }

    public static void sumupProblems() {
        IvyDEMessage.getLogger().sumupProblems();
    }

    public static void progress() {
        IvyDEMessage.getLogger().progress();
    }

    public static void endProgress() {
        IvyDEMessage.getLogger().endProgress();
    }

    public static void endProgress(String msg) {
        IvyDEMessage.getLogger().endProgress(msg);
    }

    public static boolean isShowProgress() {
        return IvyDEMessage.getLogger().isShowProgress();
    }

    public static void setShowProgress(boolean progress) {
        IvyDEMessage.getLogger().setShowProgress(progress);
    }

    public static void debug(String message, Throwable t) {
        if (t == null) {
            IvyDEMessage.debug(message);
        } else {
            IvyDEMessage.debug(String.valueOf(message) + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            IvyDEMessage.debug(t);
        }
    }

    public static void verbose(String message, Throwable t) {
        if (t == null) {
            IvyDEMessage.verbose(message);
        } else {
            IvyDEMessage.verbose(String.valueOf(message) + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            IvyDEMessage.debug(t);
        }
    }

    public static void info(String message, Throwable t) {
        if (t == null) {
            IvyDEMessage.info(message);
        } else {
            IvyDEMessage.info(String.valueOf(message) + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            IvyDEMessage.debug(t);
        }
    }

    public static void warn(String message, Throwable t) {
        if (t == null) {
            IvyDEMessage.warn(message);
        } else {
            IvyDEMessage.warn(String.valueOf(message) + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            IvyDEMessage.debug(t);
        }
    }

    public static void error(String message, Throwable t) {
        if (t == null) {
            IvyDEMessage.error(message);
        } else {
            IvyDEMessage.error(String.valueOf(message) + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            IvyDEMessage.debug(t);
        }
    }

    public static void debug(Throwable t) {
        IvyDEMessage.debug(IvyDEMessage.getStackTrace(t));
    }

    private static String getStackTrace(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)sw, true);
        e.printStackTrace(printWriter);
        return sw.getBuffer().toString();
    }
}

