/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainer;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerSerializer;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerState;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathResolver;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.apache.ivyde.internal.eclipse.resolve.IvyResolveJob;
import org.apache.ivyde.internal.eclipse.resolve.ResolveRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;

public class IvyClasspathContainerImpl
implements IClasspathContainer,
IvyClasspathContainer {
    private IClasspathEntry[] classpathEntries;
    private IPath path;
    private IvyClasspathContainerConfiguration conf;
    private final IvyClasspathContainerState state;
    private ResolveReport resolveReport;

    public IvyClasspathContainerImpl(IJavaProject javaProject, IPath path, IClasspathEntry[] classpathEntries, IClasspathAttribute[] attributes) {
        this.path = path;
        this.conf = new IvyClasspathContainerConfiguration(javaProject, path, false, attributes);
        this.state = new IvyClasspathContainerState(this.conf);
        this.classpathEntries = classpathEntries;
    }

    public IvyClasspathContainerImpl(IvyClasspathContainerImpl cp) {
        this.path = cp.path;
        this.conf = cp.conf;
        this.classpathEntries = cp.classpathEntries;
        this.state = cp.state;
        this.resolveReport = cp.resolveReport;
    }

    public IvyClasspathContainerConfiguration getConf() {
        return this.conf;
    }

    public void setConf(IvyClasspathContainerConfiguration conf) {
        this.conf = conf;
        this.state.setConf(conf);
    }

    public IvyClasspathContainerState getState() {
        return this.state;
    }

    public String getDescription() {
        return "Ivy";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.classpathEntries;
    }

    public IStatus launchResolve(boolean usePreviousResolveIfExist, IProgressMonitor monitor) {
        ResolveRequest request = new ResolveRequest(new IvyClasspathResolver(this, usePreviousResolveIfExist), this.getState());
        request.setInWorkspace(this.getConf().getInheritedClasspathSetup().isResolveInWorkspace());
        request.setTransitive(this.getConf().getInheritedClasspathSetup().isTransitiveResolve());
        IvyResolveJob resolveJob = IvyPlugin.getDefault().getIvyResolveJob();
        if (monitor != null) {
            return resolveJob.launchRequest(request, monitor);
        }
        resolveJob.addRequest(request);
        return Status.OK_STATUS;
    }

    void updateClasspathEntries(IClasspathEntry[] newEntries) {
        IvyDEMessage.verbose("Updating the classpath container " + this.toString());
        IClasspathEntry[] entries = newEntries != null ? newEntries : new IClasspathEntry[]{};
        this.setClasspathEntries(entries);
    }

    private void setClasspathEntries(final IClasspathEntry[] entries) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (IvyClasspathContainerImpl.this.conf.getInheritedClasspathSetup().isAlphaOrder()) {
                    Arrays.sort(entries, new Comparator(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            return ((IClasspathEntry)o1).getPath().lastSegment().compareTo(((IClasspathEntry)o2).getPath().lastSegment());
                        }
                    });
                }
                IvyDEMessage.debug("Setting the classpath container " + IvyClasspathContainerImpl.this.toString() + " with " + Arrays.toString(entries));
                IvyClasspathContainerImpl.this.classpathEntries = entries;
                IvyClasspathContainerImpl.this.notifyUpdateClasspathEntries();
            }
        });
    }

    void notifyUpdateClasspathEntries() {
        if (this.conf.getJavaProject() == null) {
            return;
        }
        try {
            JavaCore.setClasspathContainer((IPath)this.path, (IJavaProject[])new IJavaProject[]{this.conf.getJavaProject()}, (IClasspathContainer[])new IClasspathContainer[]{new IvyClasspathContainerImpl(this)}, null);
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
        }
        IvyClasspathContainerSerializer serializer = IvyPlugin.getDefault().getIvyClasspathContainerSerializer();
        serializer.save(this.conf.getJavaProject());
    }

    public URL getReportUrl() {
        Ivy ivy = this.state.getCachedIvy();
        if (ivy == null) {
            return null;
        }
        ModuleDescriptor md = this.state.getCachedModuleDescriptor(ivy);
        if (md == null) {
            return null;
        }
        String resolveId = IvyClasspathUtil.buildResolveId(this.conf.getInheritedAdvancedSetup().isUseExtendedResolveId(), md);
        try {
            return ivy.getResolutionCacheManager().getConfigurationResolveReportInCache(resolveId, md.getConfigurationsNames()[0]).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void reloadSettings() {
        this.state.setIvySettingsLastModified(-1L);
        this.launchResolve(false, null);
    }

    public String toString() {
        return this.conf.toString();
    }

    public void setResolveReport(ResolveReport resolveReport) {
        this.resolveReport = resolveReport;
    }

    public ResolveReport getResolveReport() {
        return this.resolveReport;
    }
}

