/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyAttachementManager;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IvyClasspathContainerSerializer {
    private static final String ROOT = "ivydecontainers";
    private static final String IVYCP = "ivycp";
    private static final String PATH = "path";
    private static final String PROJECT = "project";
    private static final String CPENTRIES = "cpentries";
    private static final String CPATTRS = "cpattrs";
    private static final String ATTR = "attr";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String CPENTRY = "cpentry";
    private static final String KIND = "kind";
    private static final String SOURCE = "source";
    private static final String ACCESS_RULES = "accessRules";
    private static final String RULE = "rule";
    private static final String PATTERN = "pattern";
    private File containersStateDir;
    private IvyAttachementManager ivyAttachementManager;

    public IvyClasspathContainerSerializer(File containersStateDir, IvyAttachementManager ivyAttachementManager) {
        this.containersStateDir = containersStateDir;
        this.ivyAttachementManager = ivyAttachementManager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(IJavaProject project) {
        List ivycps = IvyClasspathContainerHelper.getContainers(project);
        try {
            File file = new File(this.containersStateDir, String.valueOf(project.getProject().getName()) + ".xml");
            IvyDEMessage.verbose("Saving the state of the containers of the project " + project.getProject().getName() + " into " + file);
            FileOutputStream out = new FileOutputStream(file);
            try {
                this.write(out, ivycps);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_8 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                out.close();
                return;
            }
        }
        catch (Exception ioe) {
            IvyPlugin.logWarn("IvyDE container states of the project " + project.getProject().getName() + " cound not be saved", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map read(IJavaProject project) {
        File file = new File(this.containersStateDir, String.valueOf(project.getProject().getName()) + ".xml");
        IvyDEMessage.verbose("Loading the state of the containers of the project " + project.getProject().getName() + " from " + file);
        if (!file.exists()) {
            IvyPlugin.logWarn("IvyDE container states of the project " + project.getProject().getName() + " doesn't exist.");
            return null;
        }
        try {
            Map map;
            FileInputStream in = new FileInputStream(file);
            try {
                map = this.read(in);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
            return map;
        }
        catch (Exception ioe) {
            IvyPlugin.logWarn("IvyDE container states of the project " + project.getProject().getName() + " cound not be read", ioe);
            return null;
        }
    }

    private void write(OutputStream out, List containers) throws IOException {
        try {
            StreamResult result = new StreamResult(out);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(ROOT);
            document.appendChild(root);
            Iterator it = containers.iterator();
            while (it.hasNext()) {
                IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)it.next();
                Element node = document.createElement(IVYCP);
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr attr = document.createAttribute(PATH);
                attr.setValue(ivycp.getPath().toString());
                attributes.setNamedItem(attr);
                attr = document.createAttribute(PROJECT);
                attr.setValue(ivycp.getConf().getProject().getName());
                attributes.setNamedItem(attr);
                this.writeCpEntries(ivycp, document, node, ivycp.getClasspathEntries());
                this.writeCpAttr(ivycp, document, node, ivycp.getConf().getAttributes());
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void writeCpEntries(IvyClasspathContainerImpl ivycp, Document document, Node node, IClasspathEntry[] classpathEntries) {
        if (classpathEntries == null) {
            return;
        }
        Element cpEntriesNode = document.createElement(CPENTRIES);
        node.appendChild(cpEntriesNode);
        int i = 0;
        while (i < classpathEntries.length) {
            Element cpEntryNode = document.createElement(CPENTRY);
            cpEntriesNode.appendChild(cpEntryNode);
            int kind = classpathEntries[i].getEntryKind();
            NamedNodeMap attributes = cpEntryNode.getAttributes();
            Attr attr = document.createAttribute(KIND);
            attr.setValue(Integer.toString(kind));
            attributes.setNamedItem(attr);
            attr = document.createAttribute(PATH);
            attr.setValue(classpathEntries[i].getPath().toString());
            attributes.setNamedItem(attr);
            IPath source = classpathEntries[i].getSourceAttachmentPath();
            if (source != null) {
                attr = document.createAttribute(SOURCE);
                attr.setValue(source.toString());
                attributes.setNamedItem(attr);
            }
            this.writeAccessRules(ivycp, document, cpEntryNode, classpathEntries[i].getAccessRules());
            this.writeCpAttr(ivycp, document, cpEntryNode, classpathEntries[i].getExtraAttributes());
            ++i;
        }
    }

    private void writeAccessRules(IvyClasspathContainerImpl ivycp, Document document, Node cpEntryNode, IAccessRule[] accessRules) {
        if (accessRules == null) {
            return;
        }
        Element accessRulesNode = document.createElement(ACCESS_RULES);
        cpEntryNode.appendChild(accessRulesNode);
        int i = 0;
        while (i < accessRules.length) {
            Element accessRuleNode = document.createElement(RULE);
            accessRulesNode.appendChild(accessRuleNode);
            NamedNodeMap attributes = accessRuleNode.getAttributes();
            Attr attr = document.createAttribute(PATTERN);
            attr.setValue(accessRules[i].getPattern().toString());
            attributes.setNamedItem(attr);
            attr = document.createAttribute(KIND);
            attr.setValue(Integer.toString(accessRules[i].getKind()));
            attributes.setNamedItem(attr);
            ++i;
        }
    }

    private void writeCpAttr(IvyClasspathContainerImpl ivycp, Document document, Node node, IClasspathAttribute[] attrs) {
        if (attrs == null) {
            return;
        }
        Element cpAttrsNode = document.createElement(CPATTRS);
        node.appendChild(cpAttrsNode);
        int i = 0;
        while (i < attrs.length) {
            Element attrNode = document.createElement(ATTR);
            cpAttrsNode.appendChild(attrNode);
            NamedNodeMap attributes = attrNode.getAttributes();
            Attr attr = document.createAttribute(NAME);
            attr.setValue(attrs[i].getName());
            attributes.setNamedItem(attr);
            attr = document.createAttribute(VALUE);
            attr.setValue(attrs[i].getValue());
            attributes.setNamedItem(attr);
            ++i;
        }
    }

    public Map read(InputStream in) throws IOException, SAXException {
        try {
            InputSource source = new InputSource(in);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(source);
            NodeList elements = document.getElementsByTagName(IVYCP);
            HashMap<Path, IvyClasspathContainerImpl> ivycps = new HashMap<Path, IvyClasspathContainerImpl>();
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Path path = new Path(this.getMandatoryAttribute(attributes, PATH, IVYCP));
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getMandatoryAttribute(attributes, PROJECT, IVYCP));
                IJavaProject project = JavaCore.create((IProject)p);
                IClasspathEntry[] cpEntries = new IClasspathEntry[]{};
                IClasspathAttribute[] cpAttributes = null;
                NodeList children = node.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node item = children.item(j);
                    if (item.getNodeName().equals(CPENTRIES)) {
                        cpEntries = this.readCpEntries(item);
                    } else if (item.getNodeName().equals(CPATTRS)) {
                        cpAttributes = this.readCpAttr(item);
                    }
                    ++j;
                }
                IvyClasspathContainerImpl ivycp = new IvyClasspathContainerImpl(project, (IPath)path, cpEntries, cpAttributes);
                ivycps.put(path, ivycp);
                ++i;
            }
            return ivycps;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private IClasspathEntry[] readCpEntries(Node cpEntries) throws IOException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        NodeList children = cpEntries.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IClasspathEntry cpEntry;
            Node item = children.item(i);
            if (item.getNodeName().equals(CPENTRY) && (cpEntry = this.readCpEntry(item)) != null) {
                entries.add(cpEntry);
            }
            ++i;
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private IClasspathEntry readCpEntry(Node cpEntryNode) throws IOException {
        IClasspathEntry entry;
        NamedNodeMap attributes = cpEntryNode.getAttributes();
        int kind = Integer.parseInt(this.getMandatoryAttribute(attributes, KIND, CPENTRY));
        Path path = new Path(this.getMandatoryAttribute(attributes, PATH, CPENTRY));
        String source = this.getAttribute(attributes, SOURCE);
        Path sourcePath = null;
        if (source != null) {
            sourcePath = new Path(source);
        }
        IClasspathAttribute[] cpAttrs = null;
        IAccessRule[] accessRules = null;
        NodeList children = cpEntryNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            if (item.getNodeName().equals(CPATTRS)) {
                cpAttrs = this.readCpAttr(item);
            } else if (item.getNodeName().equals(ACCESS_RULES)) {
                accessRules = this.readAccessRules(item);
            }
            ++i;
        }
        switch (kind) {
            case 2: {
                entry = JavaCore.newProjectEntry((IPath)path, (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])cpAttrs, (boolean)true);
                break;
            }
            case 1: {
                IPath sources = this.ivyAttachementManager.getSourceAttachment((IPath)path, (IPath)sourcePath);
                IPath sourcesRoot = this.ivyAttachementManager.getSourceAttachmentRoot((IPath)path, (IPath)sourcePath);
                entry = JavaCore.newLibraryEntry((IPath)path, (IPath)sources, (IPath)sourcesRoot, (IAccessRule[])accessRules, (IClasspathAttribute[])cpAttrs, (boolean)false);
                break;
            }
            default: {
                return null;
            }
        }
        return entry;
    }

    private IAccessRule[] readAccessRules(Node accessRulesNode) throws IOException {
        ArrayList<IAccessRule> rules = new ArrayList<IAccessRule>();
        NodeList children = accessRulesNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IAccessRule rule;
            Node item = children.item(i);
            if (item.getNodeName().equals(RULE) && (rule = this.readAccessRule(item)) != null) {
                rules.add(rule);
            }
            ++i;
        }
        return rules.toArray(new IAccessRule[rules.size()]);
    }

    private IAccessRule readAccessRule(Node ruleNode) throws IOException {
        NamedNodeMap attributes = ruleNode.getAttributes();
        int kind = Integer.parseInt(this.getMandatoryAttribute(attributes, KIND, RULE));
        Path pattern = new Path(this.getMandatoryAttribute(attributes, PATTERN, RULE));
        return JavaCore.newAccessRule((IPath)pattern, (int)kind);
    }

    private IClasspathAttribute[] readCpAttr(Node cpAttrsNode) throws IOException {
        ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
        NodeList children = cpAttrsNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IClasspathAttribute attr;
            Node item = children.item(i);
            if (item.getNodeName().equals(ATTR) && (attr = this.readAttr(item)) != null) {
                attrs.add(attr);
            }
            ++i;
        }
        return attrs.toArray(new IClasspathAttribute[attrs.size()]);
    }

    private IClasspathAttribute readAttr(Node attrNode) throws IOException {
        NamedNodeMap attributes = attrNode.getAttributes();
        String name = this.getMandatoryAttribute(attributes, NAME, ATTR);
        String value = this.getMandatoryAttribute(attributes, VALUE, ATTR);
        return JavaCore.newClasspathAttribute((String)name, (String)value);
    }

    private String getMandatoryAttribute(NamedNodeMap attributes, String name, String owner) throws IOException {
        String att = this.getAttribute(attributes, name);
        if (att == null) {
            throw new IOException("Incorrect saved classpath: no '" + name + "' attribute on '" + name + "'");
        }
        return att;
    }

    private String getAttribute(NamedNodeMap attributes, String name) throws IOException {
        Node node = attributes.getNamedItem(name);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }
}

