/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.resolve;

import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.core.event.download.EndArtifactDownloadEvent;
import org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.apache.ivy.core.event.download.StartArtifactDownloadEvent;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.eclipse.core.runtime.IProgressMonitor;

public class IvyResolveJobListener
implements TransferListener,
IvyListener {
    private static final int KILO_BITS_UNIT = 1024;
    private static final int RESOLVE_PERCENT = 2;
    private long totalLength = 1L;
    private int workPerArtifact = 0;
    private long currentLength = 0L;
    private int currentProgress = 0;
    private final IProgressMonitor monitor;
    private final int downloadStep;
    private int resolveStep;

    public IvyResolveJobListener(IProgressMonitor monitor, int step) {
        this.monitor = monitor;
        this.resolveStep = step / 2;
        this.downloadStep = step - this.resolveStep;
    }

    public void transferProgress(TransferEvent evt) {
        switch (evt.getEventType()) {
            case 0: {
                this.monitor.subTask("downloading " + evt.getResource());
                break;
            }
            case 1: {
                this.currentLength = 0L;
                this.currentProgress = 0;
                if (!evt.isTotalLengthSet()) break;
                this.totalLength = evt.getTotalLength();
                this.monitor.subTask("downloading " + evt.getResource() + ": 0 / " + this.totalLength / 1024L + "kB");
                break;
            }
            case 3: {
                if (this.totalLength <= 1L) break;
                this.currentLength += evt.getLength();
                int progress = (int)(this.currentLength * (long)this.workPerArtifact / this.totalLength);
                this.monitor.worked(progress - this.currentProgress);
                this.currentProgress = progress;
                this.monitor.subTask("downloading " + evt.getResource() + ": " + this.currentLength / 1024L + " / " + this.totalLength / 1024L + "kB");
                break;
            }
            case 2: {
                this.monitor.worked(this.workPerArtifact - this.currentProgress);
            }
        }
    }

    public void progress(IvyEvent event) {
        if (event instanceof TransferEvent) {
            this.transferProgress((TransferEvent)event);
        } else if (event instanceof PrepareDownloadEvent) {
            PrepareDownloadEvent pde = (PrepareDownloadEvent)event;
            Artifact[] artifacts = pde.getArtifacts();
            if (artifacts.length > 0) {
                this.workPerArtifact = this.downloadStep / artifacts.length;
            } else {
                this.monitor.worked(this.downloadStep);
            }
        } else if (event instanceof StartArtifactDownloadEvent) {
            StartArtifactDownloadEvent evt = (StartArtifactDownloadEvent)event;
            this.monitor.subTask("downloading " + evt.getArtifact());
        } else if (event instanceof EndArtifactDownloadEvent) {
            this.monitor.worked(this.workPerArtifact - this.currentProgress);
            this.currentProgress = 0;
            this.monitor.subTask(" ");
        } else if (event instanceof StartResolveDependencyEvent) {
            StartResolveDependencyEvent ev = (StartResolveDependencyEvent)event;
            ModuleRevisionId mrid = ev.getDependencyDescriptor().getDependencyRevisionId();
            this.monitor.subTask("looking for " + mrid);
        } else if (event instanceof EndResolveDependencyEvent) {
            this.monitor.subTask(" ");
        } else if (event instanceof EndResolveEvent) {
            this.monitor.worked(this.resolveStep);
        }
    }
}

