/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.apache.ivyde.eclipse.cp.ClasspathSetup;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.apache.ivyde.internal.eclipse.ui.RetrieveComposite;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ClasspathSetupEditor
extends Composite {
    private static final int INDENT_BUTTONS = 0;
    private static final int INDENT_RETRIEVE = 60;
    public static final String TOOLTIP_ACCEPTED_TYPES = "Comma separated list of artifact types to add to the classpath.\nExample: jar, zip";
    private Button resolveInWorkspaceCheck;
    private Button transitiveResolveCheck;
    private Label alphaOrderLabel;
    private Combo alphaOrderCheck;
    private Button selectCache;
    private Button selectRetrieve;
    private RetrieveComposite retrieveComposite;
    private Label acceptedTypesLabel;
    private Text acceptedTypesText;
    private Button readOSGiMetadataCheck;
    private boolean osgiAvailable;

    public ClasspathSetupEditor(Composite parent, int style, IProject project) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.osgiAvailable = IvyPlugin.getDefault().isOsgiAvailable();
        this.resolveInWorkspaceCheck = new Button((Composite)this, 32);
        this.resolveInWorkspaceCheck.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.resolveInWorkspaceCheck.setText("Resolve dependencies in workspace");
        this.resolveInWorkspaceCheck.setToolTipText("Will replace jars on the classpath with workspace projects");
        this.transitiveResolveCheck = new Button((Composite)this, 32);
        this.transitiveResolveCheck.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.transitiveResolveCheck.setText("Resolve dependencies transitively");
        this.transitiveResolveCheck.setToolTipText("If uncheck, will resolve dependency with transitivity disabled regardless to the settings in ivy.xml");
        this.readOSGiMetadataCheck = new Button((Composite)this, 32);
        this.readOSGiMetadataCheck.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.readOSGiMetadataCheck.setText("Read OSGi metadata");
        this.readOSGiMetadataCheck.setToolTipText("Will setup access rules regarding OSGi metadata like Export-Package");
        this.readOSGiMetadataCheck.setEnabled(this.osgiAvailable);
        this.acceptedTypesLabel = new Label((Composite)this, 0);
        this.acceptedTypesLabel.setText("Accepted types:");
        this.acceptedTypesText = new Text((Composite)this, 2052);
        this.acceptedTypesText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.acceptedTypesText.setToolTipText(TOOLTIP_ACCEPTED_TYPES);
        this.alphaOrderLabel = new Label((Composite)this, 0);
        this.alphaOrderLabel.setText("Order of the classpath entries:");
        this.alphaOrderCheck = new Combo((Composite)this, 8);
        this.alphaOrderCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.alphaOrderCheck.setToolTipText("Order of the artifacts in the classpath container");
        this.alphaOrderCheck.add("From the ivy.xml");
        this.alphaOrderCheck.add("Lexical");
        Label label = new Label((Composite)this, 0);
        label.setText("Build the classpath with:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        gridData.horizontalIndent = 0;
        buttons.setLayoutData((Object)gridData);
        this.selectCache = new Button(buttons, 16);
        this.selectCache.setText("Ivy's cache");
        this.selectRetrieve = new Button(buttons, 16);
        this.selectRetrieve.setText("retrieved artifacts");
        this.retrieveComposite = new RetrieveComposite(this, 0, false, project);
        gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.horizontalIndent = 60;
        this.retrieveComposite.setLayoutData(gridData);
        this.selectRetrieve.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClasspathSetupEditor.this.retrieveComposite.setEnabled(ClasspathSetupEditor.this.selectRetrieve.getSelection());
            }
        });
    }

    public void init(ClasspathSetup setup) {
        this.resolveInWorkspaceCheck.setSelection(setup.isResolveInWorkspace());
        this.transitiveResolveCheck.setSelection(setup.isTransitiveResolve());
        this.readOSGiMetadataCheck.setSelection(setup.isReadOSGiMetadata());
        this.acceptedTypesText.setText(IvyClasspathUtil.concat(setup.getAcceptedTypes()));
        this.alphaOrderCheck.select(setup.isAlphaOrder() ? 1 : 0);
        this.selectCache.setSelection(!setup.isRetrievedClasspath());
        this.selectRetrieve.setSelection(setup.isRetrievedClasspath());
        this.retrieveComposite.init(setup.getRetrieveSetup());
        this.retrieveComposite.setEnabled(setup.isRetrievedClasspath());
    }

    public ClasspathSetup getClasspathSetup() {
        ClasspathSetup setup = new ClasspathSetup();
        setup.setResolveInWorkspace(this.resolveInWorkspaceCheck.getSelection());
        setup.setTransitiveResolve(this.transitiveResolveCheck.getSelection());
        setup.setReadOSGiMetadata(this.readOSGiMetadataCheck.getSelection());
        setup.setAcceptedTypes(IvyClasspathUtil.split(this.acceptedTypesText.getText()));
        setup.setAlphaOrder(this.alphaOrderCheck.getSelectionIndex() == 1);
        setup.setRetrievedClasspath(this.selectRetrieve.getSelection());
        if (setup.isRetrievedClasspath()) {
            setup.setRetrieveSetup(this.retrieveComposite.getRetrieveSetup());
        }
        return setup;
    }

    public void setEnabled(boolean enabled) {
        this.resolveInWorkspaceCheck.setEnabled(enabled);
        this.transitiveResolveCheck.setEnabled(enabled);
        this.readOSGiMetadataCheck.setEnabled(this.osgiAvailable && enabled);
        this.acceptedTypesLabel.setEnabled(enabled);
        this.acceptedTypesText.setEnabled(enabled);
        this.alphaOrderLabel.setEnabled(enabled);
        this.alphaOrderCheck.setEnabled(enabled);
        this.selectCache.setEnabled(enabled);
        this.selectRetrieve.setEnabled(enabled);
        this.retrieveComposite.setEnabled(this.selectRetrieve.getSelection() && enabled);
        super.setEnabled(enabled);
    }
}

